updateModels()
{

	if (1<2)
		return; // now handled by the distance-checking-function

	if (!mod\config::CONFIG_testing())
		return;

	for (i=0; i<level.wp.size; i++)
	{
		wp = level.wp[i];
		
		// waypoint got deleted with graph-vertex-delete
		if (!isDefined(level.wp[i]))
		{
			iprintln("waypoint " + i + " is undefined");
			continue;
		}
		if (isDefined(wp.model))
			wp.model delete();

		origin = wp.origin;
		teddy = spawn("script_model", origin);
		teddy.angles = (0,90,0);
		teddy setmodel("xmodel/prop_bear_detail_sitting");
		
		
		from = origin;
		
		if (isDefined(wp.stukamodels))
		{
			//iprintln(i + " is defined");
			//iprintln("stukamodels.size = " + wp.stukamodels.size);
			for (ii=0; ii<wp.stukamodels.size; ii++)
			{
				wp.stukamodels[ii] delete();
				//iprintln(i+"["+ii+"] deleted");
			}
		} else {
			//iprintln(i + " is NOT defined");
		}
		
		// now create the links with xmodel/military_flak88_shell
		wp.stukamodels = [];
		for (ii=0; ii<wp.next.size; ii++)
		{
			id = wp.next[ii];
			
			// next-wp got deleted with graph-vertex-delete
			if (!isDefined(level.wp[id]))
			{
				iprintln(i + ".next=" + id + " undefined");
				continue;
			}
			
			to = level.wp[id].origin;
			delta = to - from;
			delta = vectorNormalize(delta);
			padding = utils\math::vectorScale(delta, 30);
			flak = spawn("script_model", origin + padding + (0,0,5));
			flak.angles = vectorToAngles(delta);
			flak setmodel("xmodel/prop_stuka_bomb");
			
			wp.stukamodels[wp.stukamodels.size] = flak;
		}
		
		wp.model = teddy;
	}
}

drawModelsNearPlayers()
{
	if (!mod\config::CONFIG_testing())
		return;

	while (!isDefined(level.wp))
		wait 0.05;
		
	iprintln("mod\\waypoints.gsc: drawModelsNearPlayers() started");
		
	while (1)
	{
		wait 0.20;
		
		players = getEntArray("player", "classname");
		//iprintln("players:"+players.size);
		
		for (i=0; i<players.size; i++)
		{
			player = players[i];
			
			for (ii=0; ii<level.wp.size; ii++)
			{
				wp = level.wp[ii];
				
				if (distance(player.origin, wp.origin) < 700 || isDefined(wp.forceUpdate))
				{
					// bei lschen wp flaggen, das es neugemacht werden muss
				
					if (isDefined(wp.forceUpdate))
					{
						if (isDefined(wp.stukamodels))
						{
							for (iii=0; iii<wp.stukamodels.size; iii++)
							{
								stukamodel = wp.stukamodels[iii];
								stukamodel delete();
							}
							wp.stukamodels = undefined;
						}
					}
				
					if (!isDefined(wp.model))
					{
						wp.model = spawn("script_model", wp.origin);
						wp.model setModel("xmodel/prop_bear_detail_sitting");
					}
					
					if (!isDefined(wp.stukamodels))
					{
						// now create the links with xmodel/military_flak88_shell
						wp.stukamodels = [];
						for (iii=0; iii<wp.next.size; iii++)
						{
							id = wp.next[iii];
							
							// next-wp got deleted with graph-vertex-delete
							if (!isDefined(level.wp[id]))
							{
								iprintln(i + ".next=" + id + " undefined");
								continue;
							}
							
							from = wp.origin; // self wp
							to = level.wp[id].origin; // linked wp
							delta = to - from;
							delta = vectorNormalize(delta);
							padding = utils\math::vectorScale(delta, 30);
							flak = spawn("script_model", wp.origin + padding + (0,0,5));
							flak.angles = vectorToAngles(delta);
							flak setmodel("xmodel/prop_stuka_bomb");
							
							wp.stukamodels[wp.stukamodels.size] = flak;
						}
					}
				} else {
					if (isDefined(wp.model))
					{
						wp.model delete();
					}
					if (isDefined(wp.stukamodels))
					{
						for (iii=0; iii<wp.stukamodels.size; iii++)
						{
							stukamodel = wp.stukamodels[iii];
							stukamodel delete();
						}
						wp.stukamodels = undefined;
					}
				}
			}
		}
	}
		
	for (i=0; i<level.wp.size; i++)
	{
		wp = level.wp[i];
		
		// waypoint got deleted with graph-vertex-delete
		if (!isDefined(level.wp[i]))
		{
			iprintln("waypoint " + i + " is undefined");
			continue;
		}
		if (isDefined(wp.model))
			wp.model delete();

		origin = wp.origin;
		teddy = spawn("script_model", origin);
		teddy.angles = (0,90,0);
		teddy setmodel("xmodel/prop_bear_detail_sitting");
		
		
		from = origin;
		
		if (isDefined(wp.stukamodels))
		{
			//iprintln(i + " is defined");
			//iprintln("stukamodels.size = " + wp.stukamodels.size);
			for (ii=0; ii<wp.stukamodels.size; ii++)
			{
				wp.stukamodels[ii] delete();
				//iprintln(i+"["+ii+"] deleted");
			}
		} else {
			//iprintln(i + " is NOT defined");
		}
		
		// now create the links with xmodel/military_flak88_shell
		wp.stukamodels = [];
		for (ii=0; ii<wp.next.size; ii++)
		{
			id = wp.next[ii];
			
			// next-wp got deleted with graph-vertex-delete
			if (!isDefined(level.wp[id]))
			{
				iprintln(i + ".next=" + id + " undefined");
				continue;
			}
			
			to = level.wp[id].origin;
			delta = to - from;
			delta = vectorNormalize(delta);
			padding = utils\math::vectorScale(delta, 30);
			flak = spawn("script_model", origin + padding + (0,0,5));
			flak.angles = vectorToAngles(delta);
			flak setmodel("xmodel/prop_stuka_bomb");
			
			wp.stukamodels[wp.stukamodels.size] = flak;
		}
		
		wp.model = teddy;
	}
}