precache()
{
	precacheModel("xmodel/prop_tombstone7");
	precacheShader("white");
	precacheShader("headicon_dead");
	level.fxDeath = loadfx("fx/zombots/death_effect.efx");
}

showHud()
{
	player = self;

	deltaX = -40;
	deltaY = 120;
	
	if (!isDefined(player.revive_healthback))
	{
		player.revive_healthback = newClientHudElem(player);
		player.revive_healthback.archived = true;
		player.revive_healthback.horzAlign = "fullscreen";
		player.revive_healthback.vertAlign = "fullscreen";
		player.revive_healthback.alignX = "left";
		player.revive_healthback.alignY = "top";
		player.revive_healthback.x = 539 + deltaX; //547;
		player.revive_healthback.y = 455 + deltaY;
		player.revive_healthback setShader("gfx/hud/hud@health_back.tga", 90, 12);
	}
	
	if (!isDefined(player.revive_healthbar))
	{
		player.revive_healthbar = newClientHudElem(player);
		player.revive_healthbar.archived = true;
		player.revive_healthbar.horzAlign = "fullscreen";
		player.revive_healthbar.vertAlign = "fullscreen";
		player.revive_healthbar.alignX = "left";
		player.revive_healthbar.alignY = "top";
		player.revive_healthbar.x = 540 + deltaX; //548;
		player.revive_healthbar.y = 456 + deltaY - 1;
		player.revive_healthbar.color = ( 1, 0, 0);
		player.revive_healthbar setShader("gfx/hud/hud@health_bar.tga", 88, 12);
	}
	
	if (!isDefined(player.revivePoints))
		player.revivePoints = 0;
	percent = (player.revivePoints/10);
	
	player.revive_healthback.x = 320 + deltaX;
	player.revive_healthback.y = 240 + deltaY;
	player.revive_healthback setShader("gfx/hud/hud@health_back.tga", 88, 10);
	
	player.revive_healthbar.x = 320 + deltaX;
	player.revive_healthbar.y = 240 + deltaY + 2 - 1;
	
	size = int(88 * percent);
	if (size <= 0)
	{
		size = 1; // hud will crash else
		
		// well, just hide dead zombies
		player.revive_healthback.x = 1000;
		player.revive_healthbar.x = 1000;
	}
	player.revive_healthbar setShader("gfx/hud/hud@health_bar.tga", size, 8);
}

deleteHUD()
{
	player = self;
	
	if (isDefined(player.revive_healthback))
		player.revive_healthback destroy();
	
	if (isDefined(player.revive_healthbar))
		player.revive_healthbar destroy();
}

REVIVE_add()
{
	player = self;
	
	gravestone = spawn("script_model", player.origin);
	gravestone setModel("xmodel/prop_tombstone7");
	
	player.reviveTill = getTime() + 30000;
	player.revivePoints = 0;
	
	gravestone rotateYaw(360 * 30, 30, 0, 30);
	
	
	
	hud = newHudElem();
	hud.alpha = 0.80;
	hud.archived = false;
	//hud setShader("gfx/hud/death_suicide.tga", 20, 20);
	hud setShader("headicon_dead", 15, 15);
	hud setWayPoint(1); // 1=scaleWithDistance, 0=constantSmall
	entity = gravestone;
	offset = (0,0,30);
	hud.x = entity.origin[0] + offset[0];
	hud.y = entity.origin[1] + offset[1];
	hud.z = entity.origin[2] + offset[2];
	hud.color = (1,0,0);
	
	
	
	while (
		isDefined(player) &&
		(player.reviveTill > getTime()) &&
		(player.revivePoints < 10)
	)
	{
	
		//percent = 
	
		//gravestone move
		points = 0;
		
		players = utils\utils::getAlivePlayers();
		if (mod\config::CONFIG_testing())
			players = utils\utils::getPlayers();
			
		for (i=0; i<players.size; i++)
		{
			if (!mod\config::CONFIG_testing())
			{
				// in the first run the died player is seen as alive
				if (players[i] == player)
					continue;
			}
			if (distance(players[i].origin, gravestone.origin) < 50)
			{
				//players[i] iprintlnbold("^1" + player.revivePoints + "^7/^110 = ^1+20$");
				players[i] utils\money::addMoney(20);
				players[i] showHud();
				points++;
			} else {
				
				players[i] deleteHud();
			}
		}
		
		player.revivePoints += points;
		
		//iprintln("points=" + points);
		
		//playfx(level.fxDeath, gravestone.origin);
		wait 1.00;
	}
	
	players = utils\utils::getPlayers();
		
	// delete all the huds of the ppl, who still have it from the while()
	for (i=0; i<players.size; i++)
		players[i] deleteHud();
	
	respawnPosition = gravestone.origin;
	
	hud destroy();
	gravestone delete();
	
	if (!isDefined(player))
		return;
	
	if (player.revivePoints >= 10)
	{
		player.spawnAllowed = true;
		player [[level.spawnplayer]](respawnPosition);
		player.spawnAllowed = undefined;
		iprintln(player.name + " got revived!");
	}
	else
		iprintln(player.name + " died!");
		
}