
showHud(toHealing)
{
	player = self;

	deltaX = -40;
	deltaY = 120;
	
	if (!isDefined(player.healing_healthcross))
	{
		player.healing_healthcross = newClientHudElem(player);
		player.healing_healthcross.archived = true;
		player.healing_healthcross.horzAlign = "fullscreen";
		player.healing_healthcross.vertAlign = "fullscreen";
		player.healing_healthcross.alignX = "left";
		player.healing_healthcross.alignY = "top";
		player.healing_healthcross.x = 320 + deltaX + 45 + 10 - 20; /*getcvarint("tmp")*/
		player.healing_healthcross.y = 240 + deltaY + 20;
		player.healing_healthcross setShader("gfx/hud/hud@health_cross.tga", 20, 20);
	}
	
	if (!isDefined(player.healing_healthback))
	{
		player.healing_healthback = newClientHudElem(player);
		player.healing_healthback.archived = true;
		player.healing_healthback.horzAlign = "fullscreen";
		player.healing_healthback.vertAlign = "fullscreen";
		player.healing_healthback.alignX = "left";
		player.healing_healthback.alignY = "top";
		player.healing_healthback.x = 539 + deltaX;
		player.healing_healthback.y = 455 + deltaY + 50;
		player.healing_healthback setShader("gfx/hud/hud@health_back.tga", 90, 12);
	}
	
	if (!isDefined(player.healing_healthbar))
	{
		player.healing_healthbar = newClientHudElem(player);
		player.healing_healthbar.archived = true;
		player.healing_healthbar.horzAlign = "fullscreen";
		player.healing_healthbar.vertAlign = "fullscreen";
		player.healing_healthbar.alignX = "left";
		player.healing_healthbar.alignY = "top";
		player.healing_healthbar.x = 540 + deltaX;
		player.healing_healthbar.y = 456 + deltaY - 1  + 50;
		player.healing_healthbar.color = ( 1, 0, 0);
		player.healing_healthbar setShader("gfx/hud/hud@health_bar.tga", 88, 12);
	}
	

	percent = (toHealing.health/toHealing.maxhealth);
	
	player.healing_healthback.x = 320 + deltaX;
	player.healing_healthback.y = 240 + deltaY + 50;
	player.healing_healthback setShader("gfx/hud/hud@health_back.tga", 88, 10);
	
	player.healing_healthbar.x = 320 + deltaX;
	player.healing_healthbar.y = 240 + deltaY + 2 - 1 + 50;
	
	size = int(88 * percent);
	if (size <= 0)
	{
		size = 1; /* hud will crash else*/
		
		/* well, just hide dead zombies */
		player.healing_healthback.x = 1000;
		player.healing_healthbar.x = 1000;
	}
	player.healing_healthbar setShader("gfx/hud/hud@health_bar.tga", size, 8);
}

deleteHUD()
{
	player = self;
	
	if (isDefined(player.healing_healthcross))
		player.healing_healthcross destroy();
		
	if (isDefined(player.healing_healthback))
		player.healing_healthback destroy();
	
	if (isDefined(player.healing_healthbar))
		player.healing_healthbar destroy();
}

playerHealing()
{
	player = self;
	
	while (1)
	{
		wait 1;
		
		if (!isDefined(player))
			break;
		
		players = utils\utils::getAlivePlayers();
		if (mod\config::CONFIG_testing())
			players = utils\utils::getPlayers();
		
		for (i=0; i<players.size; i++)
		{
			if (player == players[i])
				continue;
			if (players[i].sessionstate != "playing")
			{
				player deleteHUD();
				continue;
			}
			if (distance(player.origin, players[i].origin) < 50)
			{
				if (players[i].health < players[i].maxhealth)
				{
				
					player showHUD(players[i]);
					players[i].health += 10;
					
					if (players[i].health > players[i].maxhealth)
						players[i].health = players[i].maxhealth;
					
					player utils\money::addMoney(20);
				} else {
					player deleteHUD();
				}
			} else {
				player deleteHUD();
			}
		}
		
		
	}
}