onPlayerConnect()
{
	player = self;
	
	while (isDefined(player))
	{
		iprintln("nearest wp=" + rotu\waypoints::getNearestWP(player.origin));
		wait 1;
	}
}

onPlayerMenuResponse()
{
	player = self;
	while (isDefined(player))
	{
		player waittill("menuresponse", menu, response);
		//iprintln("menuresponse = ", menu, ", ", response);
		
		args = strtok(response, "-");
		// 0-3 are secure to access now
		if (!isDefined(args[0])) args[0] = "";
		if (!isDefined(args[1])) args[1] = "";
		if (!isDefined(args[2])) args[2] = "";
		if (!isDefined(args[3])) args[3] = "";
		
		if (args[0] == "noattack")
		{
			if (isDefined(level.noAttack))
				level.noAttack = undefined;
			else
				level.noAttack = true;
		}
		
		if (args[0] == "graph")
		{
			if (args[1] == "new")
			{
				graph = mod\graph::GRAPH_new();
				iprintln("pointer to graph=" + graph);
			}
			if (args[1] == "test")
			{
				graph = mod\graph::GRAPH_new();
				mod\graph::GRAPH_add_vertex(graph, 100, 100, 100); // 0
				mod\graph::GRAPH_add_vertex(graph, 200, 200, 200); // 1
				mod\graph::GRAPH_add_vertex(graph, 300, 300, 300); // 2
				mod\graph::GRAPH_add_vertex(graph, 400, 400, 400); // 3
				mod\graph::GRAPH_add_edge(graph, 0, 1);
				mod\graph::GRAPH_add_edge(graph, 1, 2);
				mod\graph::GRAPH_add_edge(graph, 2, 3);
				mod\graph::GRAPH_build(graph);
				mod\graph::GRAPH_do_astar(graph, 3, 0);
				mod\graph::GRAPH_delete(graph);
			}
			if (args[1] == "save")
			{
				output = "DUMP WAYPOINTS TO FILE=''" + args[2] + "''";
				ret = meatbot\_mbot::dumpWPs(args[2]);
				if (ret)
					output += " STATUS=SUCCESS";
				else
					output += " STATUS=ERROR";
				iprintln(output);
			}
			if (args[1] == "load")
			{
				output = "LOAD WAYPOINTS OF FILE=''" + args[2] + "''";
				ret = meatbot\_mbot::buildNodeInfo(args[2]);
				if (ret)
					output += " STATUS=SUCCESS";
				else
					output += " STATUS=ERROR";
				iprintln(output);
				mod\waypoints::updateModels();
			}
			if (args[1] == "rebuild")
			{
				mod\graph::GRAPH_delete(level.graph);
				
				graph = mod\graph::GRAPH_new();
				for (i=0; i<level.wp.size; i++)
				{
					wp = level.wp[i].origin;
					mod\graph::GRAPH_add_vertex(graph, wp[0], wp[1], wp[2]);
				}
				for (i=0; i<level.wp.size; i++)
				{
					wp = level.wp[i];
					next = wp.next;
					for (ii=0; ii<wp.next.size; ii++)
						mod\graph::GRAPH_add_edge(graph, i, next[ii]);
				}
				mod\graph::GRAPH_build(graph);
				level.graph = graph;
				iprintln("GRAPH GOT REBUILDED");
			}
			
			if (args[1] == "add")
			{
				wp = spawnStruct();
				wp.origin = player getOrigin();
				wp.type = "w";
				wp.next = [];
				// todo: make connection with bulletTrace-test
				//wp.next[0] = rotu\waypoints::getNearestWP(player getOrigin());
				wp.stance = 0;
				wp.forceUpdate = true;
				
				if (!isDefined(level.wp))
					level.wp = [];
				
				level.wp[level.wp.size] = wp;
				
				mod\waypoints::updateModels();
				iprintln("test");
				
			}
			
			if (args[1] == "debug")
			{
				for (i=0; i<level.wp.size; i++)
				{
					wp = level.wp[i];
					
					tmp = "";
					for (ii=0; ii<wp.next.size; ii++)
						tmp += wp.next[ii] + " ";
					iprintln("wp["+i+"] origin=",wp.origin," next="+tmp);
				}
			}
			
			if (args[1] == "clean")
			{
				
				for (a=0; a<level.wp.size; a++)
				{
					// delete edges
					for (i=0; i<level.wp[a].stukamodels.size; i++)
						level.wp[a].stukamodels[i] delete();
					level.wp[a].stukamodels = [];
					
					// delete vertex
					level.wp[a].model delete();
				}
				
				level.wp = [];
			}
		}
		
		if (args[0] == "fractionTrace")
		{
			iprintln("fractionTrace");
			closer(14, player.origin, player.origin+(0,0,-1000));
		}
		
		if (args[0] == "zombie")
		{
			n = int(args[1]);
			n = 1;
			iprintln("ZOMBIE GOT ADDED!");
			for (i=0; i<n; i++)
			{
				mod\zombie::spawnZombie();
			}
		}
		
		if (args[0] == "graph")
		if (args[1] == "edge")
		if (args[2] == "add")
		{
			// todo [1] == "add"
			//
			
			wp1 = undefined;
			wp2 = undefined;
			
			model1 = spawn("script_model", (0,0,-10000));
			model1 setModel("xmodel/military_flak88_shell");
			model2 = spawn("script_model", (0,0,-10000));
			model2 setModel("xmodel/military_flak88_shell");
			
			// as long f is pressed, do nothing
			while (player useButtonPressed())
				wait 0.05;
			
			// adjust the wp1 aslong f is not pressed
			while (!player useButtonPressed())
			{
				lookat = player utils\player::lookAt();
				if (!isDefined(lookat))
					continue;
				wp1 = rotu\waypoints::getNearestWP(lookat);
				model1.origin = level.wp[wp1].origin;
				//iprintln();
				wait 0.05;
			}
			
			// as long f is pressed, do nothing
			while (player useButtonPressed())
				wait 0.05;
			
			// adjust the wp1 aslong f is not pressed
			while (!player useButtonPressed())
			{
				lookat = player utils\player::lookAt();
				if (!isDefined(lookat))
					continue;
				wp2 = rotu\waypoints::getNearestWP(lookat);
				model2.origin = level.wp[wp2].origin;
				//iprintln();
				wait 0.05;
			}
			model1 delete();
			model2 delete();
			level.wp[wp1].forceUpdate = true;
			iprintln("EDGE FROM="+wp1+" TO="+wp2);
			level.wp[wp1].next[level.wp[wp1].next.size] = wp2;
			mod\waypoints::updateModels();
		}
		
		if (args[0] == "graph")
		if (args[1] == "edge")
		if (args[2] == "delete")
		{
			
			wp = undefined;
			
			model = spawn("script_model", (0,0,-10000));
			model setModel("xmodel/military_flak88_shell");
			
			// as long f is pressed, do nothing
			while (player useButtonPressed())
				wait 0.05;
			
			// adjust the wp1 aslong f is not pressed
			while (!player useButtonPressed())
			{
				lookat = player utils\player::lookAt();
				if (!isDefined(lookat))
					continue;
				wp = rotu\waypoints::getNearestWP(lookat);
				model.origin = level.wp[wp].origin;
				//iprintln();
				wait 0.05;
			}
			

			model delete();
			
			iprintln("DELETE EDGES FROM="+wp);
			for (i=0; i<level.wp[wp].stukamodels.size; i++)
				level.wp[wp].stukamodels[i] delete();
			level.wp[wp].stukamodels = [];
			level.wp[wp].next = [];
			//level.wp[wp1].next[level.wp[wp1].next.size] = wp2;
			//mod\waypoints::updateModels();
		}
		
		if (args[0] == "graph")
		if (args[1] == "vertex")
		if (args[2] == "move")
		{
			wp = undefined;
			
			model = spawn("script_model", (0,0,-10000));
			model setModel("xmodel/military_flak88_shell");
			
			// as long f is pressed, do nothing
			while (player useButtonPressed())
				wait 0.05;
			
			// adjust the wp aslong f is not pressed
			while (!player useButtonPressed())
			{
				lookat = player utils\player::lookAt();
				if (!isDefined(lookat))
					continue;
				wp = rotu\waypoints::getNearestWP(lookat);
				model.origin = level.wp[wp].origin;
				//iprintln();
				wait 0.05;
			}
			model delete();
			
			player iprintln("MOVING WP:"+wp);
			
			// as long f is pressed, do nothing
			while (player useButtonPressed())
				wait 0.05;
			
			// adjust the wp aslong f is not pressed
			while (!player useButtonPressed())
			{
				wait 0.05;
				level.wp[wp].origin = player.origin;
			}
			
			iprintln("new position set");
		}
		
		if (args[0] == "graph")
		if (args[1] == "vertex")
		if (args[2] == "delete")
		{
			
			wp = undefined;
			
			model = spawn("script_model", (0,0,-10000));
			model setModel("xmodel/military_flak88_shell");
			
			// as long f is pressed, do nothing
			while (player useButtonPressed())
				wait 0.05;
			
			// adjust the wp aslong f is not pressed
			while (!player useButtonPressed())
			{
				lookat = player utils\player::lookAt();
				if (!isDefined(lookat))
					continue;
				wp = rotu\waypoints::getNearestWP(lookat);
				model.origin = level.wp[wp].origin;
				//iprintln();
				wait 0.05;
			}
			

			model delete();
			
			iprintln("DELETE VERTEX="+wp);
			for (i=0; i<level.wp[wp].stukamodels.size; i++)
				level.wp[wp].stukamodels[i] delete();
			level.wp[wp].stukamodels = [];
			level.wp[wp].model delete();
			level.wp = rotu\data::removeFromArray(level.wp, level.wp[wp]);
			
			// fix the indexes because one got deleted
			for (i=0; i<level.wp.size; i++)
			{
				for (ii=0; ii<level.wp[i].next.size; ii++)
					if (level.wp[i].next[ii] > wp)
						level.wp[i].next[ii]--;
			}
			
			
			//level.wp[wp1].next[level.wp[wp1].next.size] = wp2;
			mod\waypoints::updateModels();
		}
		
	}
	// that got shown
	//iprintln("thread ended.");
}

moneyEffect(amount)
{
	// todo: if player disconnected -> end

	player = self;
	
	hud1 = newClientHudElem(player);
	hud1.x = 320 - 10; // dollar before amount
	hud1.y = 120 - 3;
	hud1.fontscale = 1.5;
	hud1.label = game["hud_dollar"];
	//hud1 setText(game["hud_dollar"], "asd");

	hud2 = newClientHudElem(player);
	hud2.x = 320;
	hud2.y = 120;
	hud2 setValue(amount);
	
	
	hud1 fadeOverTime(4);
	hud2 fadeOverTime(4);
	hud1.alpha = 0;
	hud2.alpha = 0;
	
	
	old1X = hud1.x;
	old1Y = hud1.y;
	old2X = hud2.x;
	old2Y = hud2.y;
	for (i=0; i<4; i++)
	{
		hud1 moveOverTime(0.50*2);
		hud2 moveOverTime(0.50*2);
		deltaX = randomInt(50);
		deltaY = randomInt(50);
		
		old1X -= deltaX;
		old1Y -= deltaY;
		old2X -= deltaX;
		old2Y -= deltaY;
		
		hud1.x = old1X;
		hud1.y = old1Y;
		hud2.x = old2X;
		hud2.y = old2Y;
		
		wait 0.50*2;
	}


	hud1 destroy();
	hud2 destroy();
}

playerHudMoney()
{
	player = self;
	
	hud1 = newClientHudElem(player);
	hud1.horzAlign = "fullscreen";
	hud1.vertAlign = "fullscreen";
	hud1.alignX = "right";
	hud1.alignY = "top";
	hud1.x = 550;
	hud1.y = 250;
	hud1.label = game["hud_money"];

	hud2 = newClientHudElem(player);
	hud2.horzAlign = "fullscreen";
	hud2.vertAlign = "fullscreen";
	hud2.alignX = "left";
	hud2.alignY = "top";
	hud2.x = 550 + 5;
	hud2.y = 250 - 5;
	hud2.fontscale = 1.5;
	
	oldValue = player utils\money::getMoney();
	hud2 setValue(player utils\money::getMoney());
	while (isDefined(player))
	{
		wait 0.05;
		
		
		newValue = player utils\money::getMoney();
		
		if (oldValue == newValue)
			continue;
		
		hud2 setValue(player utils\money::getMoney());
		
		difference = newValue - oldValue;
		//player iprintlnbold("^1" + difference + " ^7$");
		player thread moneyEffect(difference);
		
		oldValue = player utils\money::getMoney();
	}
}

waittillConnectedPlayer()
{
	while (1)
	{
		level waittill("connected", player);
		//player thread onPlayerConnect();
		player thread onPlayerMenuResponse();
		player thread utils\healthbar::run();
		player thread playerHudMoney();
		player thread mod\healing::playerHealing();
		player setClientCvar("download", ""); // haha trolls :D
		player setClientCvar("ui_allow_joinallies", "0");
		player setClientCvar("ui_allow_joinaxis", "0");
		player setClientCvar("ui_allow_joinauto", "1");
		player setClientCvar("g_TeamName_Allies", "^1H^7unters");
		player setClientCvar("g_TeamName_Axis", " ");

		//player.pers["weapon"] = "mp44_mp"; // default weapon if the didnt choose anyone
		player thread mod\rank::onPlayerConnect();
	}
}



theGametype()
{	
	level.leftToSpawn = 200;
	level.spawnAtOnce = 20;
	
	thread mod\waypoints::drawModelsNearPlayers();
	
	if (mod\config::CONFIG_testing())
	{
		// set the teddies and stuka-bombs
		mod\waypoints::updateModels();
	
		zombie = spawnStruct();
		zombie.health = 180;
		zombie.points = 5;
		zombie.model = "xmodel/character_german_winter_masked_dark";
		zombie.speed = 160;
	
		type = zombie;
		mod\zombie::spawnZombie(type.health, type.points, type.model, type.speed, type.effect, type.bashOnly);
		
		return;
	}
	
	// we wont spawn anything before the waypoints arent defined
	while (!isDefined(level.wp))
		wait 0.05;

	while (!isDefined(level.spawnpointZombie))
		wait 0.05;
		
	//iprintln("waypoints and spawnpoints loaded!");
	
	if (mod\config::CONFIG_mod() == "teufel")
	{
		zombie = spawnStruct();
		zombie.health = 180;
		zombie.points = 5;
		zombie.model = "xmodel/zombie";
		zombie.speed = 160;
		zombieBoss = spawnStruct();
		zombieBoss.health = 360;
		zombieBoss.points = 15;
		zombieBoss.model = "xmodel/zombie";
		zombieBoss.speed = 120;
		zombieBoss.effect = level.fx["tank_fire_engine"];
		
		pluxy = spawnStruct();
		pluxy.health = 180;
		pluxy.points = 8;
		pluxy.model = "xmodel/pluxy";
		pluxy.speed = 140;
		pluxyBoss = spawnStruct();
		pluxyBoss.health = 450;
		pluxyBoss.points = 20;
		pluxyBoss.model = "xmodel/pluxy";
		pluxyBoss.speed = 140;
		pluxyBoss.effect = level.fx["tank_fire_engine"];
		
		charple = spawnStruct();
		charple.health = 200;
		charple.points = 10;
		charple.model = "xmodel/charple";
		charple.speed = 150;
		charpleBoss = spawnStruct();
		charpleBoss.health = 480;
		charpleBoss.points = 25;
		charpleBoss.model = "xmodel/charple";
		charpleBoss.speed = 100;
		charpleBoss.effect = level.fx["tank_fire_engine"];
		
		arab = spawnStruct();
		arab.health = 360;
		arab.points = 50;
		arab.model = "xmodel/arab";
		arab.speed = 95;
		arabBoss = spawnStruct();
		arabBoss.health = 540;
		arabBoss.points = 75;
		arabBoss.model = "xmodel/arab";
		arabBoss.speed = 95;
		arabBoss.effect = level.fx["tank_fire_engine"];
		
		robo = spawnStruct();
		robo.health = 5000;
		robo.points = 500;
		robo.model = "xmodel/robo";
		robo.speed = 80;
		roboBoss = spawnStruct();
		roboBoss.health = 5000;
		roboBoss.points = 500;
		roboBoss.model = "xmodel/robo";
		roboBoss.speed = 80;
		roboBoss.bashOnly = true;
		roboBoss.effect = level.fx["tank_fire_engine"];
		
		zombies = [];
		// easy part 1/3
		zombies[zombies.size] = zombie;
		zombies[zombies.size] = pluxy;
		zombies[zombies.size] = charple;
		zombies[zombies.size] = arab;
		// easy part 2/3
		zombies[zombies.size] = zombie;
		zombies[zombies.size] = pluxy;
		zombies[zombies.size] = charple;
		zombies[zombies.size] = arab;
		// easy part 3/3
		zombies[zombies.size] = zombie;
		zombies[zombies.size] = pluxy;
		zombies[zombies.size] = charple;
		zombies[zombies.size] = arab;
		// hard part
		zombies[zombies.size] = zombie;
		zombies[zombies.size] = arabBoss;
		zombies[zombies.size] = pluxy;
		zombies[zombies.size] = robo;
		zombies[zombies.size] = charple;
		zombies[zombies.size] = zombieBoss;
		zombies[zombies.size] = pluxyBoss;
		zombies[zombies.size] = arab;
		zombies[zombies.size] = charpleBoss;
		
		level.zombies = zombies;
	}
	
	
	if (mod\config::CONFIG_mod() == "kung")
	{
		zombie1 = spawnStruct();
		zombie1.health = 200;
		zombie1.points = 50;
		zombie1.model = "xmodel/character_german_winter_masked_dark";
		zombie1.speed = 110;
		
		zombie2 = spawnStruct();
		zombie2.health = 1000;
		zombie2.points = 500;
		zombie2.model = "xmodel/character_russian_winter_body";
		zombie2.speed = 90;
		
		zombies = [];
		
		zombies[zombies.size] = zombie1;
		zombies[zombies.size] = zombie1;
		zombies[zombies.size] = zombie1;
		zombies[zombies.size] = zombie1;
		zombies[zombies.size] = zombie1;
		zombies[zombies.size] = zombie2;

		level.zombies = zombies;
	}
	
	level.waves = [];
	level.waves[0] = 80;
	level.waves[1] = 200;
	level.waves[2] = 325;
	level.waves[3] = 425;
	level.waves[4] = 600;
	level.waves[5] = 700;
	level.waves[6] = 800;
	level.waves[7] = 900;
	level.waves[8] = 1000;
	level.waves[9] = 1100;
	level.waves[10] = 1236;
	level.waves[11] = 1340;
	level.waves[12] = 1500;
	level.waves[13] = 1624;
	level.waves[14] = 1700;
	level.waves[15] = 1790;
	level.waves[16] = 1850;
	level.waves[17] = 1950;
	level.waves[18] = 2050;
	level.waves[19] = 2222;
	
	/*
	for (i=0; i<level.waves.size; i++)
		level.waves[i] /= 20;
	*/

	hud = newHudElem();
	hud.horzAlign = "fullscreen";
	hud.vertAlign = "fullscreen";
	hud.alignX = "right";
	hud.alignY = "top";
	hud.x = 550;
	hud.y = 80;
	hud.label = game["hud_current_wave"];
	level.hud_current_wave_text = hud;
	// #####
	hud = newHudElem();
	hud.horzAlign = "fullscreen";
	hud.vertAlign = "fullscreen";
	hud.alignX = "left";
	hud.alignY = "top";
	hud.x = 550 + 5;
	hud.y = 80 - 5;
	hud.fontscale = 1.5;
	level.hud_current_wave_value = hud;

	hud = newHudElem();
	hud.horzAlign = "fullscreen";
	hud.vertAlign = "fullscreen";
	hud.alignX = "right";
	hud.alignY = "top";
	hud.x = 550;
	hud.y = 80 + 20;
	hud.label = game["hud_alive_zombies"];
	level.hud_alive_zombies_text = hud;
	// #####
	hud = newHudElem();
	hud.horzAlign = "fullscreen";
	hud.vertAlign = "fullscreen";
	hud.alignX = "left";
	hud.alignY = "top";
	hud.x = 550 + 5;
	hud.y = 80 - 5 + 20;
	hud.fontscale = 1.5;
	level.hud_alive_zombies_value = hud;

	hud = newHudElem();
	hud.horzAlign = "fullscreen";
	hud.vertAlign = "fullscreen";
	hud.alignX = "right";
	hud.alignY = "top";
	hud.x = 550;
	hud.y = 80 + 40;
	hud.label = game["hud_zombies_left"];
	level.hud_zombies_left_text = hud;
	// #####
	hud = newHudElem();
	hud.horzAlign = "fullscreen";
	hud.vertAlign = "fullscreen";
	hud.alignX = "left";
	hud.alignY = "top";
	hud.x = 550 + 5;
	hud.y = 80 - 5 + 40;
	hud.fontscale = 1.5;
	level.hud_zombies_left_value = hud;
	
	counter = 0;
	currentWave = 0;
	level.hud_current_wave_value setValue(1); // there is no wave "0"
	level.hud_alive_zombies_value setValue(0); // there is no wave "0"
	level.hud_zombies_left_value setValue(0); // there is no wave "0"
	// init
	level.leftToSpawn = int(level.waves[0]);
	
	
	setcvar("sv_hostname", "^1Z^7om^1B^7ots ^9/ ^1W^7aiting ^1F^7or ^1P^7layers ^9/ ^1B^7eta ^1M^7od");
	
	if (!mod\config::CONFIG_testing())
	{
		while (!isDefined(level.startRound))
			wait 0.05;
		
		//while (utils\utils::getAlivePlayers().size == 0)
		//	wait 0.10;
	
		/*wait 10;*/ // wait for other players to keep the map running, once its started
	
		timeToWait = 15;
		for (i=0; i<timeToWait; i++)
		{
			iprintlnbold("^1S^7tart ^1i^7n ^1" + (timeToWait - i) + "^7!");
			wait 1;
		}
	}
	
	setcvar("sv_hostname", "^1Z^7om^1B^7ots ^9/ ^1W^7ave^1:^7 1^1/^720 ^1B^7eta ^1M^7od");
			
	level.spawnAllowed = true;
	all = utils\utils::getPlayers();
	for (i=0; i<all.size;i++)
		all[i] [[level.spawnplayer]]();
		
	iprintln("players = " + all.size);
		
	level.spawnAllowed = undefined;
	
	ambientPlay("zombots_round_start");
	iprintlnbold("^1R^7ound ^1S^7tarted!");
	
	//reasonOfEnd = "allDead";
	
	while (1)
	{
		wait 0.10;
		
		// mapchange is so annoying while testing!
		if (!mod\config::CONFIG_testing())
		{
			if (utils\utils::getAlivePlayers().size == 0)
			{
				
				//break;
				iprintln("if (utils\utils::getAlivePlayers().size == 0) allPlayer="+utils\utils::getPlayers().size);
				wait 5;
			}
		}
		
		numberOfZombies = getEntArray("zombie", "targetname").size;
		
		level.hud_alive_zombies_value setValue(numberOfZombies);
		
		if (numberOfZombies == 0 && level.leftToSpawn<=0)
		{
			iprintlnbold("^1Z^7ombies ^1o^7f ^1W^7ave ^1" + (currentWave+1) + " ^1k^7illed!");
			/*iprintlnbold("^1P^7repare ^1f^7or ^1THE BOSS^1!");*/
			/*wait 5;
			iprintln("todo: dogs=" + (currentWave+1) + " and boss");
			
			wait 1;
			iprintln("3");
			wait 1;
			iprintln("2");
			wait 1;
			iprintln("1");
			wait 1;*/
			currentWave++;
			
			
			dead = utils\utils::getDeadPlayers();
			//iprintln("dead players:"+dead.size);
			
			
			level.spawnAllowed = true;
			for (i=0; i<dead.size;i++)
				dead[i] [[level.spawnplayer]]();	
			level.spawnAllowed = undefined;
			
			all = utils\utils::getPlayers();
			for (i=0; i<all.size;i++)
				all[i].health = 100;
			
			// lol im to stupid atm to evaluate this to currentWave >= level.waves.size or so
			if (!isDefined(level.waves[currentWave]))
				break; // rounds finished
			
			level.leftToSpawn = int(level.waves[currentWave]);
			level.hud_current_wave_value setValue(currentWave+1);
			
			setcvar("sv_hostname", "^1Z^7om^1B^7ots ^9/ ^1W^7ave^1:^7 " + (currentWave+1) + "^1/^720 ^1B^7eta ^1M^7od");
			
			level.spawnAtOnce = 20 + currentWave * 2;
			
			if (mod\config::CONFIG_mod() == "kung")
				maps\mp\gametypes\tdm::playSoundOnPlayers("ctf_touchcapture");
			if (mod\config::CONFIG_mod() == "teufel")
				ambientPlay("zombots_round_end");
			
			wait 10;
			ambientPlay("zombots_round_start");
			wait 5; // looks nice with round_start sound
		}
		
		if (level.leftToSpawn <= 0)
		{
			// its just spamming
			//iprintln("all zombies spawned");
			//wait 10;
			//continue;
			//break;
		}
		
		moreZombies = level.spawnAtOnce - numberOfZombies;
		
		if (!isDefined(level.lastZombie))
			level.lastZombie = getTime();
		
		if (level.lastZombie + 300 < getTime())
		{
			for (i=0; i<moreZombies; i++)
			{
				if (level.leftToSpawn <= 0)
					break;
					
				//wait 3; // delay them DEPRECATED
				/*iprintln("^1N^7ew ^1Z^7ombie ^1S^7pawned^1!");*/
				
				type = level.zombies[counter % level.zombies.size];
				counter++;
				mod\zombie::spawnZombie(type.health, type.points, type.model, type.speed, type.effect, type.bashOnly);
				level.leftToSpawn--;
				level.hud_zombies_left_value setValue(level.leftToSpawn);
				level.lastZombie = getTime();
				break; // just do one at once to update the huds
			}
		}
	}
	ambientPlay("zombots_gameover");
	if (mod\config::CONFIG_mod() == "teufel")
		wait 5;
	else
		wait 1;
/*	iprintlnbold("^1W^7ell ^1D^7one^1!");
	wait 5;
	iprintlnbold("^1Y^7ou ^1j^7ust ^1s^7topped ^1t^7he ^1Z^7ombie-^1A^7pocalypse!");
	wait 5;*/
	mod\mapvote::run();
}

onStartGameType()
{
	mod\precache::precache();
	
	setcvar("scr_spectatefree", "1");
	
	meatbot\_mbot::mbotInit();
	
	thread theGametype();
	thread waittillConnectedPlayer();

	/*
	offset = (0,0,-60);

	model1 = spawn("script_model", (169,-855,68)+offset);
	model1.angles = (0,180,0);
	model1 setModel("xmodel/zombie");

	model2 = spawn("script_model", (169,-727,68)+offset);
	model2.angles = (0,180,0);
	model2 setModel("xmodel/zombie_pluxy_infected");

	model3 = spawn("script_model", (169,-547,73)+offset);
	model3.angles = (0,180,0);
	model3 setModel("xmodel/charple");

	model4 = spawn("script_model", (169,-415,69)+offset);
	model4.angles = (0,180,0);
	model4 setModel("xmodel/sknhds_zombie_arab");

	model5 = spawn("script_model", (169,-281,70)+offset);
	model5.angles = (0,180,0);
	model5 setModel("xmodel/petx_halo_cobra_ch");*/
}

threadForDeleteHud()
{
	player  = self;
	while (1)
	{
		wait 0.05;
		
		if (!isDefined(player))
			return;
		
		// i dont delete it anymore, just put it out of window
		//if (isDefined(player.dontDeleteHud))
		//	continue;
			
		if (player.hideHudAt < getTime())
		{
			if (isDefined(player.healthcross))
				player.zom_healthcross.x = 1000;
			if (isDefined(player.healthback))
				player.zom_healthback.x = 1000;
			if (isDefined(player.healthbar))
				player.zom_healthbar.x = 1000;
		}
	}
}

ZOMBOT_show_damage(player, damage)
{
	zombie = self;
	deltaX = 7;
	deltaY = 16;
	
	player.hideHudAt = getTime() + 2500;
	
	player.dontDeleteHud = true;
	if (!isDefined(player.zom_healthcross))
	{
		player.zom_healthcross = newClientHudElem(player);
		player.zom_healthcross.archived = true;
		player.zom_healthcross.horzAlign = "fullscreen";
		player.zom_healthcross.vertAlign = "fullscreen";
		player.zom_healthcross.alignX = "right";
		player.zom_healthcross.alignY = "top";
		player.zom_healthcross.x = 535 + deltaX; //543;
		player.zom_healthcross.y = 455 + deltaY;
		player.zom_healthcross setShader("gfx/hud/hud@health_cross.tga", 10-2, 10-2);
	}
	
	if (!isDefined(player.zom_healthback))
	{
		player.zom_healthback = newClientHudElem(player);
		player.zom_healthback.archived = true;
		player.zom_healthback.horzAlign = "fullscreen";
		player.zom_healthback.vertAlign = "fullscreen";
		player.zom_healthback.alignX = "left";
		player.zom_healthback.alignY = "top";
		player.zom_healthback.x = 539 + deltaX; //547;
		player.zom_healthback.y = 455 + deltaY;
		player.zom_healthback setShader("gfx/hud/hud@health_back.tga", 90, 10-2);
	}
	
	if (!isDefined(player.zom_healthbar))
	{
		player.zom_healthbar = newClientHudElem(player);
		player.zom_healthbar.archived = true;
		player.zom_healthbar.horzAlign = "fullscreen";
		player.zom_healthbar.vertAlign = "fullscreen";
		player.zom_healthbar.alignX = "left";
		player.zom_healthbar.alignY = "top";
		player.zom_healthbar.x = 540 + deltaX; //548;
		player.zom_healthbar.y = 456 + deltaY;
		player.zom_healthbar.color = ( 0, 1, 0);
		player.zom_healthbar setShader("gfx/hud/hud@health_bar.tga", 88, 8-1);
	}
	
	deltaX = 50;
	deltaY = 100;
	player.zom_healthcross.x = 320 - 20 + deltaX + 1000;
	player.zom_healthcross.y = 240 + deltaY + 1000;
	player.zom_healthcross setShader("gfx/hud/hud@health_cross.tga", 10, 5);
	
	percent = (zombie.health/zombie.maxhealth);
	
	player.zom_healthback.x = 320 + deltaX;
	player.zom_healthback.y = 240 + deltaY;
	player.zom_healthback setShader("gfx/hud/hud@health_back.tga", 88, 7);
	
	player.zom_healthbar.x = 320 + deltaX;
	player.zom_healthbar.y = 240 + deltaY + 2;
	
	size = int(88 * percent);
	if (size <= 0)
	{
		size = 1; // hud will crash else
		
		// well, just hide dead zombies
		player.zom_healthback.x = 1000;
		player.zom_healthbar.x = 1000;
	}
	player.zom_healthbar setShader("gfx/hud/hud@health_bar.tga", size, 4);
	
	if (!isDefined(player.gotThread))
	{
		player.gotThread = true;
		player thread threadForDeleteHud();
	}
}

onPlayerDamage(eInflictor, eAttacker, iDamage, iDFlags, sMeansOfDeath, sWeapon, vPoint, vDir, sHitLoc, psOffsetTime)
{
	//self finishPlayerDamage(eInflictor, eAttacker, 1, iDFlags, sMeansOfDeath, sWeapon, vPoint, vDir, sHitLoc, psOffsetTime);
	//eAttacker finishPlayerDamage(eAttacker, eAttacker, 10, 0, "MOD_MELEE", "mine_mp", self.origin, /*vDir*/eAttacker.origin-self.origin, "none", 0);

	// sesstionteam is undefined etc.
	// stop crashing in developer=1
	// (this is the zombie-damage-section)
	//eAttacker iprintln("iDamage = " + iDamage);
	if (!isPlayer(self))
	{
		zombie = self;
		
		if (isDefined(zombie.bashOnly) && sMeansOfDeath!="MOD_MELEE")
			return true;
		
		/*
		iprintln("DEBUG self = " + self getEntityNumber());
		if (isDefined(eInflictor))
			iprintln("DEBUG inflictor = " + eInflictor getEntityNumber());
		else
			iprintln("DEBUG inflictor = NONE");
		if (isDefined(eAttacker))
			iprintln("DEBUG attacker = " + eAttacker getEntityNumber());
		else
			iprintln("DEBUG attacker = NONE");
		iprintln("DEBUG iDamage = " + iDamage);
		iprintln("DEBUG iDFlags = " + iDFlags);
		iprintln("DEBUG sMeansOfDeath = " + sMeansOfDeath);
		iprintln("DEBUG isPlayer self = " + isPlayer(self));
		iprintln("DEBUG isPlayer eAttacker = " + isPlayer(eAttacker));
		iprintln("DEBUG self.health = " + self.health);
		//iprintln("DEBUG self.sessionteam = " + self.sessionteam);
		*/
		
		//iprintln("iDamage = " + iDamage);
		
		zombie utils\assist::ASSIST_add(iDamage, eAttacker);
		
		//zombie.fakehealth -= iDamage;
		zombie.lastAttacker = eAttacker;
		zombie.health -= iDamage;
	
		// todo: das cursor-damage scriptbar machen
		//self finishPlayerDamage(eInflictor, eAttacker, iDamage, iDFlags, sMeansOfDeath, sWeapon, vPoint, vDir, sHitLoc, psOffsetTime);
		
		zombie ZOMBOT_show_damage(eAttacker, iDamage);
		
		eAttacker thread maps\mp\gametypes\_damagefeedback::updateDamageFeedback();
		
		return true;
	}

	if (isPlayer(eAttacker))
	{
		eAttacker thread maps\mp\gametypes\_damagefeedback::updateDamageFeedback();
		return true; // quit playerdamage-function
	}
	return false; // execute normal playerdamage too
}

onPlayerKilled(eInflictor, attacker, iDamage, sMeansOfDeath, sWeapon, vDir, sHitLoc, psOffsetTime, deathAnimDuration)
{
	player = self;
	player thread mod\revive::REVIVE_add();
	
	// BUNCH OF COPIED CODE:
	// BUNCH OF COPIED CODE:
	// BUNCH OF COPIED CODE:
	self endon("spawned"); // menuSpectator() ends this FUNCTION.... so it will just return undefined!
	self notify("killed_player");

	
	//if(self.sessionteam == "spectator")
	//	return;
	
	// If the player was killed by a head shot, let players know it was a head shot kill
	if(sHitLoc == "head" && sMeansOfDeath != "MOD_MELEE")
		sMeansOfDeath = "MOD_HEAD_SHOT";

	// send out an obituary message to all clients about the kill
	obituary(self, attacker, sWeapon, sMeansOfDeath);

	//self maps\mp\gametypes\_weapons::dropWeapon();
	//self maps\mp\gametypes\_weapons::dropOffhand();

	//self.sessionteam = "spectator";
	// self [[level.spectator]](); // arg, just needed scr_spectatefree = 1
	//self.sessionstate = "dead";
	self.sessionstate = "spectator";
	self.statusicon = "hud_status_dead";

	if(!isdefined(self.switching_teams))
		self.deaths++;

	lpselfnum = self getEntityNumber();
	lpselfname = self.name;
	lpselfteam = "";
	lpselfguid = self getGuid();
	lpattackerteam = "";

	attackerNum = -1;
	if(isPlayer(attacker))
	{
		if(attacker == self) // killed himself
		{
			doKillcam = false;

			if(!isdefined(self.switching_teams))
				attacker.score--;
		}
		else
		{
			attackerNum = attacker getEntityNumber();
			doKillcam = true;

			attacker.score++;
			//attacker checkScoreLimit(); // 123123231
		}

		lpattacknum = attacker getEntityNumber();
		lpattackguid = attacker getGuid();
		lpattackname = attacker.name;

		attacker notify("update_playerscore_hud");
	}
	else // If you weren't killed by a player, you were in the wrong place at the wrong time
	{
		doKillcam = false;

		self.score--;

		lpattacknum = -1;
		lpattackguid = "";
		lpattackname = "";

		self notify("update_playerscore_hud");
	}

	logPrint("K;" + lpselfguid + ";" + lpselfnum + ";" + lpselfteam + ";" + lpselfname + ";" + lpattackguid + ";" + lpattacknum + ";" + lpattackerteam + ";" + lpattackname + ";" + sWeapon + ";" + iDamage + ";" + sMeansOfDeath + ";" + sHitLoc + "\n");

	body = self cloneplayer(deathAnimDuration);
	// END OF BUNCH
	// END OF BUNCH
	// END OF BUNCH
	
	
	return true; // quit calling function
}