//======================================================
//  MBot v0.91
//
//       V.I.P.
//======================================================

#include maps\mp\mbot\_mbot;

init()
{
	mbotInit();
	
    level.wp = undefined;
    level.wp = [];
	level.botstart = ::botStart;
	level.spawnpoints = getentarray("mp_tdm_spawn", "classname");

	setcvar("addbot", "");
	setcvar("removebot", "");
	setcvar("restart", "");
	setcvar("loadmap", "");
	
	map = getCvar("mapname");
	type = getCvar("g_gametype");
  
	// Cepe7a -->
	if (getcvar("bot_debug") == "")
		setcvar("bot_debug", "0");
		
	if (getcvar("bot_viewangle") == "")
		setcvar("bot_viewangle", "60");
	
	if (getcvar("bot_maxdistance") == "")
		setcvar("bot_maxdistance", 3000);
	
	level.wpfile = (map + "_" + type + ".wp");
	if(getCvarInt("bot_debug") == 1) 
	{
		setCvar("developer", 1);
		setcvar("scr_tdm_timelimit", "0");
		level.wpfile = (map + "_" + type + ".tmp");
		bFlag = true;
		if (!buildNodeInfo(level.wpfile)) 
		{
			wpf = (map + "_" + type + ".wp");
			if (!buildNodeInfo(wpf)) 
				bFlag = false;
			else 
				maps\mp\mbot\_mbot_dev::dumpWPs(level.wpfile); //      
		}
	} else {
		if(!buildNodeInfo(level.wpfile))
			bFlag = false;
		else
			bFlag = true;
	}
	// <-- Cepe7a
  
	
	if(!bFlag && getCvarInt("bot_debug") == 0) // Cepe7a
	{
		//while(!level.mapended)
		//{
			iprintlnbold(&"MBOT_MAPNOTSUPPORT");
			//wait 9.5;
		//}
		//return;
	}

	if(getCvar("skill") == "")
		setCvar("skill", "5");
	else if (getCvarInt("skill") > 10 || getCvarInt("skill") < 0)
		setCvar("skill", "5");
	SetSkill(getCvarInt("skill")); // Cepe7a
	
	//level.botwaittime = 0.55 - (level.botskill/20);

	level.movespeed = 206; /*getCvarInt("g_speed");*/

	level.bots_al = 0;
	level.bots_ax = 0;
	bots_al = getCvarInt("scr_tmpbotsal");
	bots_ax = getCvarInt("scr_tmpbotsax");
  
	level.maprotate = getCvar("sv_mapRotationCurrent");
  
	if(getCvar("bot_autojoin") == "")
		setCvar("bot_autojoin", 1);

	if(getCvarInt("bot_autojoin") == 1)
	{
		for(i = 0; i < bots_al; i++)
		{
			wait .5;
			addBot("allies");
		}
		for(i = 0; i < bots_ax; i++)
		{
			wait .5;
			addBot("axis");
		}
	}
  
	level thread dvarCheck();
	
	level thread waitPlayer(); // Cepe7a
}

// Cepe7a -->
waitPlayer()
{
	while(1)
	{
		level waittill("connected", player);
		if (!isDefined(level.plr) || !isPlayer(level.plr))
		{
			level.plr = player;
			if(getCvarInt("bot_debug") == 1)
				level thread maps\mp\mbot\_mbot_dev::init(); // dev
		}
	}
}
// <-- Cepe7a


dvarCheck()
{
	level endon("intermission");

	for(;;)
	{
		tmp = getCvar("addbot");
		if(tmp != "")
		{
			addBot(tmp);
			setCvar("addbot", "");
		}
		
		tmp = getCvar("removebot");
		if(tmp != "")
		{
			removeBot(tmp);
			setCvar("removebot", "");
		}

		tmp = getCvarInt("skill");
		if(tmp != level.botskill)
			setSkill(tmp);

		if(getCvar("restart") == "map")
		{
			map = getCvar("mapname");
			type = getCvar("g_gametype");
     
			if(mapIsSupportBots(map, type))
			{
				loadMap(map, type);
				break;
			}
			else
			{
				println("Map ", map, "don't support bots in \"", type, "\"");
				setCvar("restart", "");
			}
		}
		else if(getCvar("restart") == "fast")
		{
			map_restart(false);
		}
		else
		{
			setCvar("restart", "");
		}

		if(getCvar("loadmap") != "")
		{
			map = getCvar("loadmap");
			type = getCvar("g_gametype");
     
			/*if(mapIsSupportBots(map, type))
			{*/
			loadMap(map, type);
			/*}
			else
			{
				println("Map ", (map + ".d3dbsp"), " not found or don't support bots and will be not loaded.");
			}*/
			setCvar("loadmap", "");
		}

		if(getCvarInt("bot_debug") != 1)
		{
			//setCvar("developer", 0);
			setCvar("sv_cheats", 0);
		}

		if(getCvar("scr_tmpmaprotation") != level.maprotate)
			setCvar("scr_tmpmaprotation", level.maprotate);

		if(getCvarInt("scr_tmpbotsal") != level.bots_al)
			setCvar("scr_tmpbotsal", level.bots_al);
		if(getCvarInt("scr_tmpbotsax") != level.bots_ax)
			setCvar("scr_tmpbotsax", level.bots_ax);
    
		if(getCvarInt("g_playerCollisionEjectSpeed") != 85)   //   checkPlayerCollision
			setCvar("g_playerCollisionEjectSpeed", 85);
		if(getCvarInt("g_speed") != 190)
			setCvar("g_speed", 190);
		if(getCvarInt("sv_fps") != 20)
			setCvar("sv_fps", 20);

		wait 0.25;
	}
}

botStart()
{
	self notify("end_botstart");
	self endon("end_botstart");
	self endon("disconnect");
  
	for(;;)
	{
		self waittill("bot_spawned");
		
		self thread botMainLoop();
    
		self waittill("killed_player");

		if(isdefined(self.botorg))
		{
			self stopMoving();
			self unlink();
			self.botorg delete();
		}
    
		if(self.pers["team"] == "spectator")
			break;
	}
}


botMainLoop()
{
	
	self endon("killed_player");
	self endon("disconnect");
	
	self.state = "camp";
	self freezecontrols(true);
	self addBotWeapon(self.pweapon, 0, 0);
	wait 1;

	self.botorg = spawn("script_origin", self.origin);
	self linkto(self.botorg);
	wait .05;
  
	self.state = "done";
	self.alert = false;
	self.next = undefined;
	
	self.skiprotate = undefined; // Cepe7a

	self setweaponslotclipammo("primary", 9999);
	self givemaxammo(self.pers["weapon"]);
	self giveBotGrenades();
	self thread checkEnemy();

	for(;;)
	{
		switch(self.state)
		{
			case "idle":
				if(!self.alert)
				{
					if(self.next.type != "w")
						self mbot_stopLoopSound();
            
					switch(self.next.type)
					{
						case "w":
							self.state = "move";
							self.next = self getNextNode();
							self thread goToNode(self.next.origin);
							break;
							
						case "g":
							if(randomInt(3))
							{
								self.state = "throw";
								self thread throwGrenade();
							}
							else
							{
								self.state = "done";
							}
							break;
							
						case "f":
							self.state = "fall";
							self thread fallGravity();
							break;
							
						case "c":
							if(randomInt(3))
							{
								self.state = "camp";
								time = randomInt(9) + 1;
								self thread makeCamp(time);
							}
							else
							{
								self.state = "done";
							}
							break;
							
						case "j":
							self.state = "jump";
							self thread jumpGravity();
							break;
							
						case "m":
							self.state = "mantle";
							self thread doMantle();
							break;
							
						case "l":
							self.state = "climb";
							self thread climbUp();
							break;
					}
				}
				else
				{
					wait 1;
				}
				break;
				
			case "move":
				if(checkBotCollision())
				{
					self thread stopMoving();

					self.pclipammo = self getweaponslotclipammo("primary");
					self setweaponslotammo("primary", 0);
					self setweaponslotclipammo("primary", 0);
					self freezecontrols(false);
          
					for(;;)
					{
						if(self.state != "camp")
							self.state = "camp";

						if(checkBotCollision())
						{
							wait randomFloat(1) + 0.1; // Cepe7a
						}
						else
						{
							self freezecontrols(true);   //    
							wait 1;
							if(!(checkBotCollision()))
								break;

							self freezecontrols(false);  //  
						}
					}

					self freezecontrols(true);
					self givemaxammo(self.pers["weapon"]);
					self setweaponslotclipammo("primary", self.pclipammo);
  
					self.state = "move";
					self thread goToNode(self.next.origin);

					break;
				}

				if(self.alert)
				{
					self thread stopMoving();

					for(;;)
					{
						if(self.alert)
						{
							wait .05;
						}
						else
						{
							wait randomFloat(1) + 1; // Cepe7a
							if(!self.alert)
								break;
						}
					}

					self.state = "move";
					self thread goToNode(self.next.origin);
					break;
				}
				wait .01;
				break;
				
			case "done":
				self.state = "move";
				self.next = self getNextNode();
				self thread goToNode(self.next.origin);
				break;
				
			default:
				wait .01;
				break;
		}    
	}
}


// Cepe7a -->
VisibleMark(player, checkallsurface)
{
	if (!isDefined(player))
		return undefined;
		
	eye = self.mark[1].origin;
	if (!isalive(player) || !isDefined(player.mark))
		return undefined;
        
	bot_maxdist = getCvarInt("bot_maxdistance");
	if (bot_maxdist < 100)
		bot_maxdist = 100;

	dist = distance(eye, player.mark[1].origin); 
	if (dist > bot_maxdist)
		return undefined;
	dist = vectornormalize(player.origin - eye);
	angles = self getplayerangles();
	vfwd = anglestoforward(angles);
	dot = vectordot(vfwd, dist);
	if (dot > 1)
		dot = 1;
	viewangle = acos(dot);
	bot_viewangle = getcvarint("bot_viewangle");
	if (viewangle > bot_viewangle)
		return undefined;
   
	for(j = 0; j < player.mark.size; j++)
	{
		if (sighttracepassed(eye, player.mark[j].origin, false, self)) 
		{
			trace = bullettrace(eye, player.mark[j].origin, true, self);
			//iprintln("^2Target: Mark:^3", j, "^2; Surface: ^3", trace["surfacetype"]); // *** TEMP
			//    
			if (checkallsurface && trace["surfacetype"] != "default" && trace["surfacetype"] != "none")
				return undefined;
						
			return player.mark[j].origin;
		}
	}
	return undefined;
}


checkEnemy()
{
	self endon("killed_player");
	self endon("disconnect");
	self.alert = false;
	self.enemy = undefined;
	target = undefined;
	waittarget = 0;

	self.pclipammo = self getweaponslotclipammo("primary");

	for(;;)
	{
		eye = self.mark[1].origin;
		newtarget = undefined; 
		target_mark = undefined;
		friendAttacker  = undefined; //     ,    
		friendDist = 99999;
		if (isDefined(target) && target.pers["team"] != self.pers["team"])
		{			
			target_mark = self VisibleMark(target, true);
		}
		if (isDefined(target_mark))
			newtarget = target;
		else
		{
			players = getentarray("player", "classname");
			for(i = 0; i < players.size; i++)
			{
				player = players[i];
				if (player.pers["team"] != self.pers["team"])
				{
					target_mark = self VisibleMark(player, true);	
					if (isDefined(target_mark))
					{
						newtarget = player;
						break;
					}	
				}
				else if (isDefined(player.isbot))
				{
					//    
					dist = distance(self.origin, player.origin);
					if (dist < 1000 && dist < friendDist && isDefined(player.alert) && player.alert)
					{
						target_mark = self VisibleMark(player, false);	
						if (isDefined(target_mark))
						{
							{
								friendAttacker = player;
								friendDist = dist;
								//iprintln("^2VISIBLE FRIEND:", dist); // *** TEMP
							}
						}
					}
				}
			}
		}
				
			
		target = newtarget;
		if (isDefined(target)) 
		{
			if (!isDefined(self.enemy) || self.enemy != target)
			{
				self.skiprotate = undefined;
				StopRotate();
				self DoRotateOrg(target_mark, 0.1);
			}
			self.enemy = target;
			if (!self.alert)
			{
				if (self.state == "camp")
				{
					self givemaxammo(self.pers["weapon"]);
					self setweaponslotclipammo("primary", self.pclipammo);
				}
				self.alert = true;
			}

			if (self.state == "idle" || self.state == "move" || self.state == "camp")
			{
				vtarget = vectorNormalize(target_mark - eye);
				self.pclipammo = self getweaponslotclipammo("primary");
				self setPlayerAngles(vectorToAngles(vtarget));
				self freezecontrols(false);
			}
			//     ,    -   :)
			waittarget = randomInt(10)+5; 
        }
		else 
		{
			if (self.alert)
			{
				if (!waittarget || (isDefined(self.enemy) && !isAlive(self.enemy)))
				{
					self.enemy = undefined;
					waittarget = 0;
				}	
				else
				{
					waittarget--;
					continue;
				}
				self.alert = false;
				self.pclipammo = self getweaponslotclipammo("primary");

				if (self.state != "camp")
				{
					self freezecontrols(true);
				}
				else
				{
					self setweaponslotammo("primary", 0);
					self setweaponslotclipammo("primary", 0);
				}				
			}
			else if (isDefined(friendAttacker) && (self.state == "move" || self.state == "camp"))
			{
				//iprintln("^2 FOUND FRIENDLY ATTACKER"); // *** TEMP
				//     ,     -     :)
				self notify("stoprotate");
				self notify("endrotate");
				wait 0.01;
	
				angles = friendAttacker getplayerangles();
				self thread DoRotateAng(angles, randomFloat(1-(level.botskill*0.1))+0.1);
				self thread BlockRotate(1);
			}

		}
		wait level.botwaittime;
	}
}
// <-- Cepe7a 
