#include maps\mp\mbot\_utils;

/*
--------------------------------------------------------------------------------------------------
level.wp:
         .origin  -  origin
         .type    -   ; <w, g, f, c, j, m, l>
         .next[]  -   
         .stance  -   ; <0 - stand, 1 - crouch, 2 - prone>
         .angles  -  ; ,  .type <g, c>
         .mode    -   <0 - up, 1 - over>; ,  .type <m>

spawn - 
w - 
g - 
f -  88
c - 
j -  88
m - 
l - 

self.state:
           idle     -     
           done     -    
           move     -   
           camp     -   
           fall     -    
           throw    -    
           jump     -   
           mantle   -   
           climb    -     
           
self.next - WP,  level.wp

--------------------------------------------------------------------------------------------------
*/

#using_animtree("multiplayer");

init()
{
  level.model = [];

  setCvar("sv_cheats", 1);
  
  setCvar("bot_printwps", "");
  setCvar("placewp", "");
  setCvar("movewp", "");
  setCvar("deletewp", 0);
  setCvar("bot_status", "");
  setCvar("bot_dumpwps", "");
  setCvar("bot_devmenu", "");
  setCvar("jumptonode", -1);
  
  // Cepe7a -->
  setCvar("bot_startwp", ""); 
  setCvar("bot_endwp", "");
  setCvar("bot_autowp", "0");
  setCvar("wp_check", "");
  setCvar("wp_gotoerror", "");
  level.startwp = undefined; 
  level.endwp = undefined;
  
  level.viewofs[0] = (8,8,48);
  level.viewofs[1] = (-8,8,48);
  level.viewofs[2] = (8,-8,48);
  level.viewofs[3] = (-8,-8,48);
  
  level.viewofs[4] = (8,8,32);
  level.viewofs[5] = (-8,8,32);
  level.viewofs[6] = (8,-8,32);
  level.viewofs[7] = (-8,-8,32);
  
  level.viewofs[8] = (8,8,16);
  level.viewofs[9] = (-8,8,16);
  level.viewofs[10] = (8,-8,16);
  level.viewofs[11] = (-8,-8,16);
  // <-- Cepe7a
     
  level.plr thread Deb();
  level.plr thread Dev();
  level.plr thread devMenu();
}

Deb()
{
	self endon("disconnect"); // Cepe7a
	
	for(i = 0; i < level.spawnpoints.size; i++)
	{
		model = spawn("script_model", level.spawnpoints[i].origin);
		model.angles = level.spawnpoints[i].angles + (0, 90, 0);
		model setmodel("xmodel/furniture_armchair");
	}
  
	for(i = 0; i < level.wp.size; i++)
		level.wp[i].selected = false;
  
	if(level.wp.size == 0) //   
	{
		for(i = 0; i < level.spawnpoints.size; i++)
		{
			vec = anglesToForward(level.spawnpoints[i].angles);
			vec = maps\mp\_utility::vectorScale(vec, 26);
      
			org = level.spawnpoints[i].origin + vec;
      
			level.plr setOrigin(org);
			spawnNode("w", false);
		}
	
		// Cepe7a -->
		dumpWPs(level.wpfile);
		bFlag = true;
		// <-- Cepe7a
	}
  
	for(;;)
	{
  
		dvar = getCvar("bot_printwps");
		if(dvar != "")
		{
			min = 0;
			max = 0;
      
			parm = strtok(dvar, " ");
			if(parm.size == 2)
			{
				min = int(parm[0]);
				max = int(parm[1]);
			}
			else
			{
				max = level.wp.size;
			}
      
			for(i = min; i < max; i++)
			{
				if(!isdefined(level.wp[i]))
					break;
          
				if(!isdefined(level.wp[i].type))
				{
					println(i, ": undefined");
					continue;
				}
				if(level.wp[i].selected)
					print("^4Selected -> ");

				print(i, ": \"", level.wp[i].type, "\"; origin - (", (level.wp[i].origin[0]+", "+level.wp[i].origin[1]+", "+level.wp[i].origin[2]), ");");
				print(" stance - ", level.wp[i].stance, "; next[", level.wp[i].next.size, "] - ");
        
				for(k = 0; k < level.wp[i].next.size; k++)
					print(" ", level.wp[i].next[k], ",");
        
				if(isdefined(level.wp[i].mode))
					print("; mode - ", level.wp[i].mode, "; ");
          
				if(isdefined(level.wp[i].angles))
					print("; angle = (", (level.wp[i].angles[0]+", "+level.wp[i].angles[1]+", "+level.wp[i].angles[2]), ")\n");
				else
					print("\n");
			}
			wait .25;
			setCvar("bot_printwps", "");
		}
    
		dvar = getCvar("bot_status");
		if(dvar != "")
		{
			players = getentarray("player", "classname");
			for(i = 0; i < players.size; i++)
			{
				if(isDefined(players[i].isbot) && players[i].name == dvar)
				{
					println("\n", players[i].name, " status:");
					println("-------------------------------------");
					println("Team: ", players[i].pers["team"]);
					println("State: ", players[i].state);
					println("IsAlive: ", isalive(players[i]));
					println("PrimaryWeapon: ", (players[i] getweaponslotweapon("primary")));
					println("PrimaryAmmo: ", (players[i] getweaponslotammo("primary")));
					println("PrimaryClipAmmo: ", (players[i] getweaponslotclipammo("primary")));
					println("SecondWeapon: ", (players[i] getweaponslotweapon("primaryb")));
					println("SecondaryAmmo: ", (players[i] getweaponslotammo("primaryb")));
					println("SecondaryClipAmmo: ", (players[i] getweaponslotclipammo("primaryb")));
					if(isdefined(players[i].botgrenade))
						println("GrenadeType: ", players[i].botgrenade);
					else
						println("GrenadeType: undefined");
					if(isdefined(players[i].botgrenadecount))
						println("GrenadesCount: ", players[i].botgrenadecount);
					else
						println("GrenadesCount: undefined");
					println("Origin: (", players[i].origin[0], ", ", players[i].origin[1], ", ", players[i].origin[2], ")");
					if(isdefined(players[i].alert))
						println("Alert: ", players[i].alert);
					else
						println("Alert: 0");
					if(isdefined(players[i].next))
						println("NextWP: ", players[i].next.next[0]);
					else
						println("NextWP: udefined");

					println("\npClipAmmo: ", players[i].pclipammo);
					println("BotOrg: ", players[i].botorg);
					println("-------------------------------------");
					break;
				}
			}	

			wait .1;
			setCvar("bot_status", "");
		}
    
		dvar = getCvar("bot_devmenu");
		if(dvar != "")
		{
			cur = self.devMenuLine.curItem;
			switch(dvar)
			{
				case "up":
					if(cur > 0)
					{
						self.devMenuLine.curItem--;
						self.devMenuLine.y -= 10;
					}
				break;
				
				case "down":
					if(cur < 6)
					{
						self.devMenuLine.curItem++;
						self.devMenuLine.y += 10;
					}
				break;
				
				case "change":
					if(self.devMenuItem[cur].alpha != 1)
						break;
            
					switch(cur)
					{
						case 1: // type
							self.devMenuItem[1].cur++;
							if(self.devMenuItem[1].cur > 6)
								self.devMenuItem[1].cur = 0;

							switch(self.devMenuItem[1].cur)
							{
								case 0: self.devMenuItem[1] setText(&"MBOTDEV_W"); break;
								case 1: self.devMenuItem[1] setText(&"MBOTDEV_G"); break;
								case 2: self.devMenuItem[1] setText(&"MBOTDEV_F"); break;
								case 3: self.devMenuItem[1] setText(&"MBOTDEV_C"); break;
								case 4: self.devMenuItem[1] setText(&"MBOTDEV_J"); break;
								case 5: self.devMenuItem[1] setText(&"MBOTDEV_M"); break;
								case 6: self.devMenuItem[1] setText(&"MBOTDEV_L"); break;
							}
              
							self.devMenuItem[1].color = (1.0, 1.0, .3);
						break;
						
						case 2: // origin
							self.devMenuItem[2] deleteVectorValue();
							self.devMenuItem[2].color = (1.0, 1.0, .3);
							self.devMenuItem[2] setVectorValue(self.origin, 50);
              
							self.devMenuItem[2].neworg = self.origin;
						break;
						
						case 4: // stance
							self.devMenuItem[4].cur++;
							if(self.devMenuItem[4].cur > 2)
								self.devMenuItem[4].cur = 0;

							switch(self.devMenuItem[4].cur)
							{
								case 0: self.devMenuItem[4] setText(&"MBOTDEV_STAND"); break;
								case 1: self.devMenuItem[4] setText(&"MBOTDEV_CROUCH"); break;
								case 2: self.devMenuItem[4] setText(&"MBOTDEV_PRONE"); break;
							}
							self.devMenuItem[4].color = (1.0, 1.0, .3);
						break;
						
						case 5: // angles
							if(self.devMenuItem[5].alpha == 1)
							{
								ang = self getPlayerAngles();
								self.devMenuItem[5].newang = (ang[0], ang[1], 0.0);
                
								self.devMenuItem[5] deleteVectorValue();
								self.devMenuItem[5].color = (1.0, 1.0, .03);
								self.devMenuItem[5] setVectorValue(self.devMenuItem[5].newang, 50);
							}
						break;
						
						case 6: // mode
							self.devMenuItem[6].cur++;
							if(self.devMenuItem[6].cur > 1)
								self.devMenuItem[6].cur = 0;

							switch(self.devMenuItem[6].cur)
							{
								case 0: self.devMenuItem[6] setText(&"MBOTDEV_UP"); break;
								case 1: self.devMenuItem[6] setText(&"MBOTDEV_OVER"); break;
							}
							self.devMenuItem[6].color = (1.0, 1.0, .3);
						break;
						
						default:
							break;
					}
				break;
				
				case "confirm":
					if(self.devMenuItem[cur].color == (1.0, 1.0, 1.0))
						break;
            
					switch(cur)
					{
						case 1: // type
							switch(self.devMenuItem[1].cur)
							{
								case 0: level.wp[level.curselwp].type = "w"; break;
								case 1: level.wp[level.curselwp].type = "g"; break;
								case 2: level.wp[level.curselwp].type = "f"; break;
								case 3: level.wp[level.curselwp].type = "c"; break;
								case 4: level.wp[level.curselwp].type = "j"; break;
								case 5: level.wp[level.curselwp].type = "m"; break;
								case 6: level.wp[level.curselwp].type = "l"; break;
							}
              
							level.wp[level.curselwp].angles = undefined;
							self.devMenuItem[5].alpha = .5;
							self.devMenuItem[5] deleteVectorValue();
              
							level.wp[level.curselwp].mode = undefined;
							self.devMenuItem[6] setText(&"MBOTDEV_EMPTY");
              
							if(self.devMenuItem[1].cur == 1 || self.devMenuItem[1].cur == 3)
							{
								ang = self getPlayerAngles();
								level.wp[level.curselwp].angles = (ang[0], ang[1], 0.0);
								self.devMenuItem[5].alpha = 1;
								self.devMenuItem[5] setVectorValue(level.wp[level.curselwp].angles, 50);
							}
              
							if(self.devMenuItem[1].cur == 5)
							{
								level.wp[level.curselwp].mode = 0;
								self.devMenuItem[6].alpha = 1;
								self.devMenuItem[6].cur = 0;
								self.devMenuItem[6] setText(&"MBOTDEV_UP");
							}

							if (isDefined(level.model[level.curselwp])) // Cepe7a
								level.model[level.curselwp] delete();
							spawnModelForNode(level.curselwp);

							self.devMenuItem[1].color = (1.0, 1.0, 1.0);
						break;
						
						case 2: // origin
							level.wp[level.curselwp].origin = self.devMenuItem[2].neworg;
							level.model[level.curselwp] moveTo(self.devMenuItem[2].neworg, 0.01, 0, 0);
							self.devMenuItem[2].color = (1.0, 1.0, 1.0);
							for(i = 0; i < 7; i++)
								self.devMenuItem[2].hud_vec[i].color = (1.0, 1.0, 1.0);
						break;
						
						case 4: // stance
							level.wp[level.curselwp].stance = self.devMenuItem[4].cur;
							self.devMenuItem[4].color = (1.0, 1.0, 1.0);
						break;
						
						case 5: // angles
							level.wp[level.curselwp].angles = self.devMenuItem[5].newang;
							level.model[level.curselwp] rotateTo((0.0, self.devMenuItem[5].newang[1], 0.0), 0.01, 0, 0);
							self.devMenuItem[5].color = (1.0, 1.0, 1.0);
							for(i = 0; i < 7; i++)
								self.devMenuItem[5].hud_vec[i].color = (1.0, 1.0, 1.0);
						break;
						
						case 6: // mode
							level.wp[level.curselwp].mode = self.devMenuItem[6].cur;
							self.devMenuItem[6].color = (1.0, 1.0, 1.0);
						break;
						
						default:
							break;
					}
				break;
			}
			setCvar("bot_devmenu", "");
		}
    
		dvar = getCvarInt("jumptonode");
		if(dvar != -1 && isdefined(level.wp[dvar]))
		{
			self setOrigin(level.wp[dvar].origin);
			// Cepe7a -->
			if (isdefined(level.curselwp)) 
			{
				level.wp[level.curselwp].selected = false;
				level.wp[level.curselwp] notify("unselect");
				wait .1;
			}
			level.curselwp = dvar;
			level.wp[dvar].selected = true;
			level.wp[dvar] thread markSelectedWP(dvar);		
			// <-- Cepe7a
			setCvar("jumptonode", -1);
		}
    
		//     256 ent's      1024 ent's   ,      
		tmp = 250;
		for(j = 0; j < level.wp.size; j++)
		{
			if(!isdefined(level.wp[j]) || !isdefined(level.wp[j].type) || level.wp[j].selected)
				continue;

			dist = distance(level.plr.origin, level.wp[j].origin);
			if(dist < 750)
			{
				if(!isdefined(level.model[j]))
					spawnModelForNode(j);
			}
			else
			{
				if(isdefined(level.model[j]))
					level.model[j] delete();
			}

			if(isdefined(level.model[j]))
			{
				if(dist < 500)
					level.model[j] show();
				else
					level.model[j] hide();
			}

			if(j > tmp) //    potential infinite loop
			{
				wait .05;
				tmp += 250;
			}
		}
    // ~
    
		wait .05;
	}
}


Dev()
{
	self endon("disconnect"); // Cepe7a
	
 curselwp = undefined;
 // Cepe7a -->
 lastview = undefined; 
 startorigin = undefined;
 lastwp = undefined;
 autowp = false;
 // <-- Cepe7a
  
 for(;;)
 {
  // Cepe7a -->
	/*dvar = getCvar("wp_free");
	if(dvar != "")
	{
		WP_Free();
		setCvar("wp_free", "");
	}*/
	
	dvar = getCvar("wp_check");
	if (dvar != "") 
	{
		CheckErrors(true);
		setCvar("wp_check", "");		
	}
	
	dvar = getCvar("wp_gotoerror");
	if (dvar != "") 
	{
		i = CheckErrors(false);
		if (i >= 0) 
		{
			self setOrigin(level.wp[i].origin);
			if (isdefined(level.curselwp)) 
			{
				level.wp[level.curselwp].selected = false;
				level.wp[level.curselwp] notify("unselect");
				wait .1;
			}
			level.wp[i].selected = true;
			level.curselwp = i;
			level.wp[i] thread markSelectedWP(i);		
		}
		setCvar("wp_gotoerror", "");		
	}
	
	dvar = getCvar("bot_startwp");
	if (dvar != "") 
	{
		if (isdefined(level.curselwp)) 
		{
			level.startwp = level.curselwp;
			iprintln(&"MBOTDEV_START_POINT", level.curselwp);
			players = getentarray("player", "classname");
			for(i = 0; i < players.size; i++)
			{
				player = players[i];
				if(player.pers["team"] == "spectator" || !isDefined(player.isbot) || !isDefined(player.mark))
					continue;
				if (!isDefined(player.mark) ||!isDefined(player.state))
					continue;
				//player notify("endrotate"); 					
				player notify("stoprotate"); 					
				player.gotostart = true;
				next = player.next;
				switch (player.state)
				{
					case "fall":
					case "climb":
					case "jump":
					case "matle":
						if (isDefined(next.next[0]))
							next = level.wp[player.next.next[0]];
						break;
				}
				player.botorg moveto(next.origin, 0.01, 0, 0);
				player.botorg waittill("movedone");
				break;
			}		
		} else if (isDefined(level.startwp)) {
			iprintln(&"MBOTDEV_START_POINT_CANCELED");
			level.startwp = undefined;
		}
		
		setCvar("bot_startwp", "");
	}
	
	dvar = getCvar("bot_endwp");
	if (dvar != "") 
	{
		if (isdefined(level.curselwp)) 
		{
			level.endwp = level.curselwp;
			iprintln(&"MBOTDEV_END_POINT", level.curselwp);
		} else if (isDefined(level.endwp)) {
			iprintln(&"MBOTDEV_END_POINT_CANCELED");
			level.endwp = undefined;
		}
		
		setCvar("bot_endwp", "");
	}
  
	dvar = getCvarInt("bot_autowp");
	if (!autowp && dvar>32) 
	{
		iprintln(&"WP_AUTO_ON", dvar);
		autowp = true;
		if (isdefined(level.curselwp)) 
		{
			level.wp[level.curselwp].selected = false;
			level.wp[level.curselwp] notify("unselect");
			wait .1;
		}
		spawnNode("w", true);
		lastwp = level.wp.size-1;
		level.wp[lastwp].selected = true;
        level.curselwp = lastwp;
        level.wp[lastwp] thread markSelectedWP(lastwp);
		lastview = level.wp[lastwp].origin;
		startorigin = lastview;
	} else if (autowp && (distance(self.origin, lastview) > 32 || dvar<32)) {
		if (dvar<32) 
		{
			iprintln(&"WP_AUTO_OFF");
			autowp = false;
			startmark = undefined;
		}
		//iprintln("Origin: ", self.origin);
		dist = distance(self.origin, startorigin);
		view = false;
		for (i=0; i<level.viewofs.size; i++)
		{
			view = bullettracepassed(self.origin+level.viewofs[i], startorigin+level.viewofs[i], false, self);
			if (!view)
				break;
		}
		
		if(!view || dist > dvar || (!autowp && dist > 32)) 
		{
			dist = level.wp.size;
			level.wp[dist] = spawnstruct();
			level.wp[dist].origin = lastview;
			level.wp[dist].type = "w";
			level.wp[dist].next = [];
			level.wp[dist].stance = 0;
			level.wp[dist].selected = false;
			spawnModelForNode(dist);
			
			level.wp[lastwp] setNextNode(dist);
			lastwp = dist;
			startorigin = lastview;	
		}
		lastview = self.origin;
	}
	if (!autowp) {
  // <-- Cepe7a
  
  
  dvar = getCvar("placewp");
  if(dvar != "" && isalive(self))
  {
    spawnNode(dvar, true);
    
    wait .5;
    setCvar("placewp", "");
  }
  
  dvar = getCvar("bot_dumpwps");
  if(dvar != "")
  {
	// Cepe7a -->
	if (dvar == "1")
		dvar = level.wpfile;
	// <-- Cepe7a
    dumpWPs(dvar);
    wait .5;
    setCvar("bot_dumpwps", "");
  }
  
  dvar = getCvar("movewp");
  if(dvar != "")
  {
    if(isdefined(level.curselwp))
    {
      n = level.curselwp;
      parm = strtok(dvar, " ");

      if(isdefined(parm[0]) && isdefined(parm[1]))
      {
        parm[1] = strtoflt(parm[1]);

        switch(parm[0])
        {
          case "y":
            level.wp[n].origin += (parm[1], 0, 0);
			if (isDefined(level.model[n])) // Cepe7a
				level.model[n] movex(parm[1], .01, 0, 0);
            break;
          case "x":
            level.wp[n].origin += (0, parm[1], 0);
			if (isDefined(level.model[n])) // Cepe7a
				level.model[n] movey(parm[1], .01, 0, 0);
            break;
          case "z":
            level.wp[n].origin += (0, 0, parm[1]);
			if (isDefined(level.model[n])) // Cepe7a
				level.model[n] movez(parm[1], .01, 0, 0);
            break;
        }
      }
    }
    wait .25;
    setCvar("movewp", "");
  }
  
  if(getCvarInt("deletewp") != 0)
  {
    if(isdefined(level.curselwp))
    {
		// Cepe7a -->
		if (isdefined(level.startwp) && level.curselwp == level.startwp) 
			level.startwp = undefined;
		if (isdefined(level.endwp) && level.curselwp == level.endwp) 
			level.endwp = undefined;
		players = getentarray("player", "classname");
		for (i=0; i<players.size; i++) if (isdefined(players[i].isbot) && players[i].next == level.wp[level.curselwp])
				players[i].next = level.wp[0];
		// <-- Cepe7a
		
      //      
      n = level.curselwp;
      last = level.wp.size - 1;
      next = undefined;
      if(level.wp[n].next.size == 1)
      {
        next = level.wp[n].next[0];
        if(next == last)
          next = n;
      }
      
      for(i = 0; i < level.wp.size; i++)
      {
        for(k = 0; k < level.wp[i].next.size; k++)
        {
          if(level.wp[i].next[k] == n)
          {
            temp = level.wp[i].next;
            temp[k] = -1;
            level.wp[i].next = undefined;
            level.wp[i].next = [];
              
            for(l = 0; l < temp.size; l++)
            {
              if(temp[l] != -1)
                level.wp[i].next[level.wp[i].next.size] = temp[l];
            }
          }
        }
      }
      
      //  
      level.wp[n] notify("unselect");
      wait .05;
      if(n != last)
        level.wp[n] = spawnstruct();
      else
        level.wp[n] = undefined;
	  if (isDefined(level.model[n])) // Cepe7a
		level.model[n] delete();
      level.curselwp = undefined;
      
      //     ,       
      if(n != last)
      {
        level.wp[n] = level.wp[last];
        spawnModelForNode(n);
        level.wp[last] = undefined;
        if(isdefined(level.model[last]))
          level.model[last] delete();
      
        //   ,    
        for(i = 0; i < level.wp.size; i++)
        {
          for(k = 0; k < level.wp[i].next.size; k++)
          {
            if(level.wp[i].next[k] == last)
            {
              level.wp[i].next[k] = n;
              break;
            }
          }
        }
      }
      
      //        ,   
      if(isdefined(next))
      {
        level.wp[next].selected = true;
        level.curselwp = next;
        level.wp[next] thread markSelectedWP(next);
      }
      level.plr notify("update_devmenu");
    }
    wait .75;
    setCvar("deletewp", 0);
  }
  
  if(self usebuttonpressed() && isdefined(self.mark))
  {
    start = self.mark[1].origin;
    forward = anglesToForward(self getplayerangles());
	  forward = maps\mp\_utility::vectorScale(forward, 2000);
	  end = start + forward;
    trace = bulletTrace(start, end, true, self);

    if(isdefined(trace["entity"]))
    {
      for(i = 0; i < level.wp.size; i++)
      {
			  if(isdefined(level.model[i]) && level.model[i] == trace["entity"])
        {
          if(level.wp[i].selected)
          {
            level.wp[i].selected = false;
            level.wp[i] notify("unselect");
            level.curselwp = undefined;
          
            level.plr notify("update_devmenu");
            break;
          }
          else
          {
            if(isdefined(level.curselwp))
            {
              level.wp[level.curselwp].selected = false;
              level.wp[level.curselwp] notify("unselect");
            }

            level.wp[i].selected = true;
            level.curselwp = i;
            level.wp[i] thread markSelectedWP(i);
            break;
          }
        }
      }
		while (self usebuttonpressed()) // Cepe7a
			wait 0.1;
    }

    self maps\mp\gametypes\_weapons::giveGrenades();  // 
		wait .1;
  }
  
  if(self meleebuttonpressed() && isdefined(level.curselwp) && isdefined(self.mark))
  {
    start = self.mark[1].origin;
    forward = anglesToForward(self getplayerangles());
	  forward = maps\mp\_utility::vectorScale(forward, 1000);
	  end = start + forward;
    trace = bulletTrace(start, end, true, self);

    if(isdefined(trace["entity"]))
    {
      for(i = 0; i < level.wp.size; i++)
      {
	  		if(isdefined(level.model[i]) && level.model[i] == trace["entity"])
        {
          if(i == level.curselwp)
            break;

          result = level.wp[level.curselwp] setNextNode(i);
          if(result == "linked")
          {
            wait 1;
            level.wp[level.curselwp].selected = false;
            level.wp[level.curselwp] notify("unselect");
            level.wp[i].selected = true;
            level.curselwp = i;
            level.wp[i] thread markSelectedWP(i);
          }
          else if(result == "unlinked")
          {
            level.wp[level.curselwp] notify("unselect");
            wait .1;
            level.wp[level.curselwp] thread markSelectedWP(level.curselwp);
          }
          break;
        }
      }
    }
    wait .5;
  }
  } // Cepe7a - if (!autowp) {
  wait .1;
 } // for(;;)
}


devMenu()
{
	self endon("disconnect"); // Cepe7a
	level endon("intermission");
  
  self.devMenuItem = [];
  
  offset = -40;
  for(i = 0 ; i < 7; i++)
  {
    self.devMenuItem[i] = newClientHudElem(self);
    self.devMenuItem[i].horzAlign = "left";
    self.devMenuItem[i].vertAlign = "middle";
    self.devMenuItem[i].x = 6;
    self.devMenuItem[i].y = offset;
    self.devMenuItem[i].font = "default";
    self.devMenuItem[i].fontscale = .75;
    self.devMenuItem[i].archived = false;
    self.devMenuItem[i].alpha = .5;
    self.devMenuItem[i].color = (1.0, 1.0, 1.0);
    
    offset += 10;
  }
  
    self.devMenuItem[0].label = (&"MBOTDEV_ITEM0");
    self.devMenuItem[1].label = (&"MBOTDEV_ITEM1");
    self.devMenuItem[2].label = (&"MBOTDEV_ITEM2");
    self.devMenuItem[3].label = (&"MBOTDEV_ITEM3");
    self.devMenuItem[4].label = (&"MBOTDEV_ITEM4");
    self.devMenuItem[5].label = (&"MBOTDEV_ITEM5");
    self.devMenuItem[6].label = (&"MBOTDEV_ITEM6");

  self.devMenuLine = newClientHudElem(self);
  self.devMenuLine.horzAlign = "left";
  self.devMenuLine.vertAlign = "middle";
  self.devMenuLine.x = 2;
  self.devMenuLine.y = -40;
  self.devMenuLine.alpha = 0.0;
  
  self.devMenuLine.curItem = 0;
  
  self.devMenuLine setShader("black", 200, 10);
  
  for(;;)
  {
    self waittill("update_devmenu");
    self updateDevMenu();
  }
}

updateDevMenu()
{
  if(isdefined(level.curselwp))
  {
    self.devMenuItem[2] deleteVectorValue();
    self.devMenuItem[3] deleteAllAddedValues();
    self.devMenuItem[5] deleteVectorValue();

    n = level.curselwp;
    for(i = 0; i < 5; i++)
      self.devMenuItem[i].alpha = 1;
      
    for(i = 0; i < 7; i++)
      self.devMenuItem[i].color = (1.0, 1.0, 1.0);

    self.devMenuItem[0] setValue(n);
    
    switch(level.wp[n].type)
    {
      case "w":
        self.devMenuItem[1].cur = 0;
        self.devMenuItem[1] setText(&"MBOTDEV_W");
        break;
      case "g":
        self.devMenuItem[1].cur = 1;
        self.devMenuItem[1] setText(&"MBOTDEV_G");
        break;
      case "f":
        self.devMenuItem[1].cur = 2;
        self.devMenuItem[1] setText(&"MBOTDEV_F");
        break;
      case "c":
        self.devMenuItem[1].cur = 3;
        self.devMenuItem[1] setText(&"MBOTDEV_C");
        break;
      case "j":
        self.devMenuItem[1].cur = 4;
        self.devMenuItem[1] setText(&"MBOTDEV_J");
        break;
      case "m":
        self.devMenuItem[1].cur = 5;
        self.devMenuItem[1] setText(&"MBOTDEV_M");
        break;
      case "l":
        self.devMenuItem[1].cur = 6;
        self.devMenuItem[1] setText(&"MBOTDEV_L");
        break;
      default:
        self.devMenuItem[1] setText(&"MBOTDEV_EMPTY");
        break;
    }
    
    self.devMenuItem[2] setVectorValue(level.wp[n].origin, 50);
    
    if(isdefined(level.wp[n].next) && level.wp[n].next.size > 0)
    {
      offset = 50;
      for(i = 0; i < level.wp[n].next.size; i++)
        offset = (self.devMenuItem[3] addValue(level.wp[n].next[i], offset));
    }
    
    switch(level.wp[n].stance)
    {
      case 0:
        self.devMenuItem[4].cur = 0;
        self.devMenuItem[4] setText(&"MBOTDEV_STAND");
        break;
      case 1:
        self.devMenuItem[4].cur = 1;
        self.devMenuItem[4] setText(&"MBOTDEV_CROUCH");
        break;
      case 2:
        self.devMenuItem[4].cur = 2;
        self.devMenuItem[4] setText(&"MBOTDEV_PRONE");
        break;
      default:
        self.devMenuItem[4] setText(&"MBOTDEV_EMPTY");
        break;
    }
    
    if(level.wp[n].type == "g" || level.wp[n].type == "c" || level.wp[n].type == "w")
    {
      self.devMenuItem[5].alpha = 1;
      self.devMenuItem[5] setVectorValue(level.wp[n].angles, 50);
    }
    else
    {
      self.devMenuItem[5].alpha = .5;
    }

    if(level.wp[n].type == "m")
    {
      self.devMenuItem[6].alpha = 1;
      switch(level.wp[n].mode)
      {
        case 0:
          self.devMenuItem[6].cur = 0;
          self.devMenuItem[6] setText(&"MBOTDEV_UP");
          break;
        case 1:
          self.devMenuItem[6].cur = 1;
          self.devMenuItem[6] setText(&"MBOTDEV_OVER");
          break;
        default:
          self.devMenuItem[6] setText(&"MBOTDEV_EMPTY");
          break;
      }
    }
    else
    {
      self.devMenuItem[6].alpha = .5;
      self.devMenuItem[6] setText(&"MBOTDEV_EMPTY");
    }

    self.devMenuLine.alpha = .4;
  }
  else
  {
    for(i = 0; i < 7; i++)
    {
      self.devMenuItem[i].alpha = .5;
      self.devMenuItem[i].color = (1.0, 1.0, 1.0);
      self.devMenuItem[i] setText(&"MBOTDEV_EMPTY");
    }
    self.devMenuItem[2] deleteVectorValue();
    self.devMenuItem[3] deleteAllAddedValues();
    self.devMenuItem[5] deleteVectorValue();

    self.devMenuLine.alpha = 0.0;
    self.devMenuLine.curItem = 0;
    self.devMenuLine.y = -40;
  }
}

//------------------------------------------------------------------------------------------
setVectorValue(vec, offset)
{
	if (!isDefined(vec))
		return;
		
  self.hud_vec = [];

  for(i = 0; i < 7; i++)
  {
    self.hud_vec[i] = newClientHudElem(level.plr);
    self.hud_vec[i].horzAlign = self.horzAlign;
    self.hud_vec[i].vertAlign = self.vertAlign;
    self.hud_vec[i].y = self.y;
    self.hud_vec[i].font = "default";
    self.hud_vec[i].fontscale = self.fontscale;
    self.hud_vec[i].archived = self.archived;
    self.hud_vec[i].alpha = self.alpha;
    self.hud_vec[i].color = self.color;
  }
  
  self.hud_vec[0].x = offset;
  self.hud_vec[1].x = offset + 4;
  self.hud_vec[2].x = offset + 40;
  self.hud_vec[3].x = offset + 44;
  self.hud_vec[4].x = offset + 90;
  self.hud_vec[5].x = offset + 94;
  self.hud_vec[6].x = offset + 130;
  
  self.hud_vec[0] setText(&"MBOTDEV_LSKOBKA");
  self.hud_vec[1] setValue(vec[0]);
  self.hud_vec[2] setText(&"MBOTDEV_ZPT");
  self.hud_vec[3] setValue(vec[1]);
  self.hud_vec[4] setText(&"MBOTDEV_ZPT");
  self.hud_vec[5] setValue(vec[2]);
  self.hud_vec[6] setText(&"MBOTDEV_PSKOBKA");
}

deleteVectorValue()
{
  if(isdefined(self.hud_vec))
  {
    for(i = 0; i < 7; i++)
      self.hud_vec[i] destroy();
      
    self.hud_vec = undefined;
  }
}

addValue(val, offset)
{
  if(!isdefined(self.hud_add))
    self.hud_add = [];

  i = self.hud_add.size;
  self.hud_add[i] = newClientHudElem(level.plr);
  self.hud_add[i].horzAlign = self.horzAlign;
  self.hud_add[i].vertAlign = self.vertAlign;
  self.hud_add[i].x = offset;
  self.hud_add[i].y = self.y;
  self.hud_add[i].font = "default";
  self.hud_add[i].fontscale = self.fontscale;
  self.hud_add[i].archived = self.archived;
  self.hud_add[i].alpha = self.alpha;
  
  self.hud_add[i] setValue(val);
  
  newoffset = offset + 6;
  if(val >= 10000)
    newoffset += 24;
  else if(val >= 1000)
    newoffset += 18;
  else if(val >= 100)
    newoffset += 12;
  else if(val >= 10)
    newoffset += 6;
  
  return newoffset;
}

deleteAllAddedValues()
{
  if(isdefined(self.hud_add))
  {
    for(i = 0; i < self.hud_add.size; i++)
      self.hud_add[i] destroy();

    self.hud_add = undefined;
  }
}

//------------------------------------------------------------------------------------------
markSelectedWP(n)
{
  self endon("unselect");
  level.plr notify("update_devmenu");

  // Cepe7a -->
  if (!isDefined(level.model[n]))
	spawnModelForNode(n);
  ring = 0;
  for(i=0; i<level.wp.size; i++)
	level.wp[i].ring = undefined;
  // <-- Cepe7a
  endwp = undefined;
  
  for(;;)
  {
	ring++; // Cepe7a
    i = n;
    while(level.wp[i].next.size == 1)
    {
      if(isDefined(level.wp[i].angles)) // Cepe7a
      {
        vec = anglesToForward(level.wp[i].angles);
        vec = maps\mp\_utility::vectorScale(vec, 128);
        end = level.wp[i].origin + vec;
        line(level.wp[i].origin, end, (1.0, 0.0, 0.0), false);
      }
      
	  level.wp[i].ring = ring; // Cepe7a
      next = level.wp[i].next[0];
      line(level.wp[i].origin, level.wp[next].origin, (.2, .8, 1.0), false);
      print3d((level.wp[next].origin + (0, 0, 15)), next, (.3, .8, 1.0), 1, 1);
	  
	  if (isdefined(level.wp[next].ring) && level.wp[next].ring == ring) break; // Cepe7a
	  
      i = next;	  
/*      if(level.wp[i].selected)
      {
        println(i, ":^3 loop detected!");
        break;
      }
*/ // Cepe7a
    }
    
    print3d((level.wp[i].origin + (0, 0, 15)), i, (1.0, .7, .7), 1, 1);
    
    if(level.wp[i].next.size > 1)
    {
      for(k = 0; k < level.wp[i].next.size; k++)
      {
        next = level.wp[i].next[k];
        line(level.wp[i].origin, level.wp[next].origin, (1.0, 1.0, 1.0), false);
        print3d((level.wp[next].origin + (0, 0, 15)), next, (1.0, 1.0, 1.0), 1, 1);
      }
    }
    
    print3d((self.origin + (0, 0, 15)), n, (1.0, 1.0, .2), 1, 1);

    wait .05;
  }
}


setNextNode(n)
{
  for(i = 0; i < self.next.size; i++)
  {
    if(self.next[i] == n)
    {
      temp = self.next;
      temp[i] = -1;
      self.next = undefined;
      self.next = [];

      for(l = 0; l < temp.size; l++)
      {
        if(temp[l] != -1)
          self.next[self.next.size] = temp[l];
      }
      return "unlinked";
    }
  }

  for(i = 0; i < level.wp[n].next.size; i++)
    if(level.wp[n].next[i] == level.curselwp)
      return "nothing";

  self.next[self.next.size] = n;
  return "linked";
}


spawnModelForNode(i)
{
	switch(level.wp[i].type)
	{
		case "w":
			level.model[i]= spawn("script_model", level.wp[i].origin);
			if (isDefined(level.wp[i].angles))	// Cepe7a
				level.model[i].angles = (0.0, level.wp[i].angles[1], 0.0);
			level.model[i] setmodel("xmodel/prop_bear");
		break;
		
		case "f":
			level.model[i]= spawn("script_model", level.wp[i].origin);
			level.model[i] setmodel("xmodel/military_flak88_shell");
		break;
		
		case "c":
			level.model[i]= spawn("script_model", level.wp[i].origin);
			level.model[i] setmodel("xmodel/furniture_toilet");
		break;
		
		case "g":
			level.model[i]= spawn("script_model", level.wp[i].origin);
			level.model[i].angles = (0.0, level.wp[i].angles[1], 0.0);
			level.model[i] setmodel("xmodel/prop_mortar");
		break;
		
		case "j":
			level.model[i]= spawn("script_model", level.wp[i].origin);
			level.model[i] setmodel("xmodel/military_flak88_shell");
		break;
		
		case "m":
			level.model[i]= spawn("script_model", level.wp[i].origin);
			level.model[i] setmodel("xmodel/prop_hydrant");
		break;
		
		case "l":
			level.model[i]= spawn("script_model", level.wp[i].origin);
			level.model[i] setmodel("xmodel/prop_hydrant");
		break;
		
		default:
		break;
	}
}

spawnNode(type, msg)
{
  i = level.wp.size;
    switch(type)
    {
      case "w":
		if (msg)
			iprintln(&"WP_TYPE_W"); // Cepe7a
        level.model[i] = spawn("script_model", self.origin);
        level.model[i] setmodel("xmodel/prop_bear");

        level.wp[i] = spawnstruct();
        level.wp[i].origin = self.origin;
        level.wp[i].type = "w";
        level.wp[i].next = [];
        level.wp[i].stance = 0;

        level.wp[i].selected = false;

        break;
      case "g":
		if (msg)
			iprintln(&"WP_TYPE_G"); // Cepe7a
        ang = self getplayerangles();

        level.model[i] = spawn("script_model", self.origin);
        level.model[i].angles = (0.0, ang[1], 0.0);
        level.model[i] setmodel("xmodel/prop_mortar");

        level.wp[i] = spawnstruct();
        level.wp[i].origin = self.origin;
        level.wp[i].type = "g";
        level.wp[i].next = [];
        level.wp[i].stance = 0;
        level.wp[i].angles = (ang[0], ang[1], 0.0);

        level.wp[i].selected = false;

        break;
      case "f":
		if (msg)
			iprintln(&"WP_TYPE_F"); // Cepe7a
        level.model[i] = spawn("script_model", self.origin);
        level.model[i] setmodel("xmodel/military_flak88_shell");

        level.wp[i] = spawnstruct();
        level.wp[i].origin = self.origin;
        level.wp[i].type = "f";
        level.wp[i].next = [];
        level.wp[i].stance = 0;

        level.wp[i].selected = false;

        break;
      case "c":
		if (msg)
			iprintln(&"WP_TYPE_C"); // Cepe7a
        level.model[i] = spawn("script_model", self.origin);
        level.model[i] setmodel("xmodel/furniture_toilet");
        ang = self getplayerangles();

        level.wp[i] = spawnstruct();
        level.wp[i].origin = self.origin;
        level.wp[i].type = "c";
        level.wp[i].next = [];
        level.wp[i].stance = 0;
        level.wp[i].angles = (ang[0], ang[1], 0.0);

        level.wp[i].selected = false;

        break;
      case "j":
		if (msg)
			iprintln(&"WP_TYPE_J"); // Cepe7a
        level.model[i] = spawn("script_model", self.origin);
        level.model[i] setmodel("xmodel/military_flak88_shell");

        level.wp[i] = spawnstruct();
        level.wp[i].origin = self.origin;
        level.wp[i].type = "j";
        level.wp[i].next = [];
        level.wp[i].stance = 0;

        level.wp[i].selected = false;

        break;
      case "m":
		if (msg)
			iprintln(&"WP_TYPE_M"); // Cepe7a
        level.model[i] = spawn("script_model", self.origin);
        level.model[i] setmodel("xmodel/prop_hydrant");

        level.wp[i] = spawnstruct();
        level.wp[i].origin = self.origin;
        level.wp[i].type = "m";
        level.wp[i].next = [];
        level.wp[i].stance = 0;
        level.wp[i].mode = 0;

        level.wp[i].selected = false;

        break;
      case "l":
		if (msg)
			iprintln(&"WP_TYPE_L"); // Cepe7a
        level.model[i] = spawn("script_model", self.origin);
        level.model[i] setmodel("xmodel/prop_hydrant");

        level.wp[i] = spawnstruct();
        level.wp[i].origin = self.origin;
        level.wp[i].type = "l";
        level.wp[i].next = [];
        level.wp[i].stance = 0;

        level.wp[i].selected = false;

        break;
      default:
        break;
    }
}


dumpWPs(file)
{
  f = openfile(file, "write");
  if(f == -1)
  {
    iprintln(&"WP_CANT_CREATE", file);
    return false;
  }

  fprintln(f, "mbotwp");
  closefile(f);

  f = openfile(file, "append");

  for(j = 0; j < level.wp.size; j++)
  {
   if(isdefined(level.wp[j].type))
   {
    switch(level.wp[j].type)
    {
      case "w":
        str = "\n" + level.wp[j].origin[0] + " " + level.wp[j].origin[1] + " " + level.wp[j].origin[2] + " w " + level.wp[j].stance + " " + level.wp[j].next.size;
        for(k = 0; k < level.wp[j].next.size; k++)
          str += (" " + level.wp[j].next[k]);
		  
		if (isDefined(level.wp[j].angles))	// Cepe7a
			str += (" " + level.wp[j].angles[0] + " " + level.wp[j].angles[1]);


        fprintln(f, str);
        break;
      case "g":
        str = "\n" + level.wp[j].origin[0] + " " + level.wp[j].origin[1] + " " + level.wp[j].origin[2] + " g " + level.wp[j].stance + " " + level.wp[j].next.size;
        for(k = 0; k < level.wp[j].next.size; k++)
          str += (" " + level.wp[j].next[k]);

        str += (" " + level.wp[j].angles[0] + " " + level.wp[j].angles[1]);

        fprintln(f, str);
        break;
      case "f":
        str = "\n" + level.wp[j].origin[0] + " " + level.wp[j].origin[1] + " " + level.wp[j].origin[2] + " f " + level.wp[j].stance + " " + level.wp[j].next.size;
        for(k = 0; k < level.wp[j].next.size; k++)
          str += (" " + level.wp[j].next[k]);

        fprintln(f, str);
        break;
      case "c":
        str = "\n" + level.wp[j].origin[0] + " " + level.wp[j].origin[1] + " " + level.wp[j].origin[2] + " c " + level.wp[j].stance + " " + level.wp[j].next.size;
        for(k = 0; k < level.wp[j].next.size; k++)
          str += (" " + level.wp[j].next[k]);

        str += (" " + level.wp[j].angles[0] + " " + level.wp[j].angles[1]);

        fprintln(f, str);
        break;
      case "j":
        str = "\n" + level.wp[j].origin[0] + " " + level.wp[j].origin[1] + " " + level.wp[j].origin[2] + " j " + level.wp[j].stance + " " + level.wp[j].next.size;
        for(k = 0; k < level.wp[j].next.size; k++)
          str += (" " + level.wp[j].next[k]);

        fprintln(f, str);
        break;
      case "m":
        str = "\n" + level.wp[j].origin[0] + " " + level.wp[j].origin[1] + " " + level.wp[j].origin[2] + " m " + level.wp[j].stance + " " + level.wp[j].next.size;
        for(k = 0; k < level.wp[j].next.size; k++)
          str += (" " + level.wp[j].next[k]);

        str += (" " + level.wp[j].mode);

        fprintln(f, str);
        break;
      case "l":
        str = "\n" + level.wp[j].origin[0] + " " + level.wp[j].origin[1] + " " + level.wp[j].origin[2] + " l " + level.wp[j].stance + " " + level.wp[j].next.size;
        for(k = 0; k < level.wp[j].next.size; k++)
          str += (" " + level.wp[j].next[k]);

        fprintln(f, str);
        break;
    }
   }
  }
  closefile(f);
  iprintln(&"WP_DUMPED", file);

  return true;
}


// Cepe7a -->
CheckErrors(showall)
{
	println("^2Checking for errors...");
	noerr = true;
	for(i = 0; i < level.wp.size; i++)
	{
		if(level.wp[i].next.size == 0) 
		{
			if (!showall)
			{
				iprintln(&"WP_WRN_NO_NEXT", i);
				return i;
			}
			println(": ^3Warning! Waypoint #" + i + " have no next waypoints");
			noerr = false;
		}
     
		if((level.wp[i].type == "f" || level.wp[i].type == "j" || level.wp[i].type == "m" || level.wp[i].type == "l") && level.wp[i].next.size > 1) 
		{
			if (!showall) 
			{
				switch(level.wp[i].type)
				{
					case "w":
						type = &"MBOTDEV_W";
						break;
					case "g":
						type = &"MBOTDEV_G";
						break;
					case "f":
						type = &"MBOTDEV_F";
						break;
					case "c":
						type = &"MBOTDEV_C";
						break;
					case "j":
						type = &"MBOTDEV_J";
						break;
					case "m":
						type = &"MBOTDEV_M";
						break;
					case "l":
						type = &"MBOTDEV_L";
						break;
					default:
						type = &"UNKNOWN";
						break;
				}
				iprintln(&"WP_WRN_MORE_ONE", i, type);
				return i;
			}
			println(": ^3Warning! Waypoint #" + i + " of type \"" + level.wp[i].type + "\" have more then one next waypoints");
			noerr = false;
		}
	}
	if (noerr) 
	{
		if (showall)
			println("^2No errors");
		else 
			iprintln(&"WP_NO_ERRORS");
		return -1;
	}

}

// <-- Cepe7a
