// MeatBot v0.91

#include meatbot\_utils;

dumpWPs(file)
{
  f = openfile(file, "write");
  if(f == -1)
  {
    iprintln("cant create file: ", file);
    return false;
  }

  fprintln(f, "mbotwp");
  closefile(f);

  f = openfile(file, "append");

  for(j = 0; j < level.wp.size; j++)
  {
   if(isdefined(level.wp[j].type))
   {
    switch(level.wp[j].type)
    {
      case "w":
        str = "\n" + level.wp[j].origin[0] + " " + level.wp[j].origin[1] + " " + level.wp[j].origin[2] + " w " + level.wp[j].stance + " " + level.wp[j].next.size;
        for(k = 0; k < level.wp[j].next.size; k++)
          str += (" " + level.wp[j].next[k]);
		  
		if (isDefined(level.wp[j].angles))	// Cepe7a
			str += (" " + level.wp[j].angles[0] + " " + level.wp[j].angles[1]);


        fprintln(f, str);
        break;
      case "g":
        str = "\n" + level.wp[j].origin[0] + " " + level.wp[j].origin[1] + " " + level.wp[j].origin[2] + " g " + level.wp[j].stance + " " + level.wp[j].next.size;
        for(k = 0; k < level.wp[j].next.size; k++)
          str += (" " + level.wp[j].next[k]);

        str += (" " + level.wp[j].angles[0] + " " + level.wp[j].angles[1]);

        fprintln(f, str);
        break;
      case "f":
        str = "\n" + level.wp[j].origin[0] + " " + level.wp[j].origin[1] + " " + level.wp[j].origin[2] + " f " + level.wp[j].stance + " " + level.wp[j].next.size;
        for(k = 0; k < level.wp[j].next.size; k++)
          str += (" " + level.wp[j].next[k]);

        fprintln(f, str);
        break;
      case "c":
        str = "\n" + level.wp[j].origin[0] + " " + level.wp[j].origin[1] + " " + level.wp[j].origin[2] + " c " + level.wp[j].stance + " " + level.wp[j].next.size;
        for(k = 0; k < level.wp[j].next.size; k++)
          str += (" " + level.wp[j].next[k]);

        str += (" " + level.wp[j].angles[0] + " " + level.wp[j].angles[1]);

        fprintln(f, str);
        break;
      case "j":
        str = "\n" + level.wp[j].origin[0] + " " + level.wp[j].origin[1] + " " + level.wp[j].origin[2] + " j " + level.wp[j].stance + " " + level.wp[j].next.size;
        for(k = 0; k < level.wp[j].next.size; k++)
          str += (" " + level.wp[j].next[k]);

        fprintln(f, str);
        break;
      case "m":
        str = "\n" + level.wp[j].origin[0] + " " + level.wp[j].origin[1] + " " + level.wp[j].origin[2] + " m " + level.wp[j].stance + " " + level.wp[j].next.size;
        for(k = 0; k < level.wp[j].next.size; k++)
          str += (" " + level.wp[j].next[k]);

        str += (" " + level.wp[j].mode);

        fprintln(f, str);
        break;
      case "l":
        str = "\n" + level.wp[j].origin[0] + " " + level.wp[j].origin[1] + " " + level.wp[j].origin[2] + " l " + level.wp[j].stance + " " + level.wp[j].next.size;
        for(k = 0; k < level.wp[j].next.size; k++)
          str += (" " + level.wp[j].next[k]);

        fprintln(f, str);
        break;
    }
   }
  }
  closefile(f);
  iprintln("waypoints written to file: ", file);

  return true;
}

mbotInit()
{
	level.velsqr = [];
	addvelsqr(12, 0.17);
	addvelsqr(25, 0.25);
	addvelsqr(37, 0.31);
	addvelsqr(50, 0.36);
	addvelsqr(75, 0.44);
	addvelsqr(100, 0.51);
	addvelsqr(125, 0.56);
	addvelsqr(150, 0.62);
	addvelsqr(175, 0.67);
	addvelsqr(200, 0.71);
	addvelsqr(250, 0.8);
	addvelsqr(300, 0.88);
	addvelsqr(350, 0.94);
	addvelsqr(400, 1.01);
	addvelsqr(450, 1.07);
	addvelsqr(500, 1.13);
	addvelsqr(600, 1.21);
	addvelsqr(650, 1.29);
	addvelsqr(700, 1.34);
	addvelsqr(750, 1.38);
	addvelsqr(800, 1.43);
	addvelsqr(850, 1.5);
	addvelsqr(900, 1.51);
	addvelsqr(1000, 1.6);
	
	//level thread addingBots();
	//buildNodeInfo("mp_toujane.wp");
}

addvelsqr(h, sqr)
{
	i = level.velsqr.size;
	level.velsqr[i] = spawnstruct();
	level.velsqr[i].h = h;
	level.velsqr[i].sqr = sqr;
}
getvelsqr(h)
{
	hprev = level.velsqr[0].h;
	for (i=1; i<level.velsqr.size; i++)
	{
		hcur = level.velsqr[i].h;
		if (h > hcur)
		{
			hprev = hcur;
			continue;
		}
		hcur = hprev + ((hcur - hprev) / 2);
		if (h < hcur)
			sqr = level.velsqr[i-1].sqr;
		else
			sqr = level.velsqr[i].sqr;
		return sqr;
	}
	
	return level.velsqr[i-1].sqr;
}


setSkill(num)
{
  if(num > 10)
    num = 10;
  else if(num < 0)
    num = 0;

  setCvar("skill", num);
    
  level.botskill = num;
  level.botwaittime = 0.55 - (level.botskill/20);
  iprintln(&"MBOT_SKILLSWITCH", level.botskill);
}


mapIsSupportBots(map, type)
{
  f = openfile((map + "_" + type + ".wp"), "read");
  if(f != -1)
  {
    closefile(f);
    return true;
  }

  return false;
}


loadMap(map, type)
{
  if(isdefined(level.plr))
  {
    setCvar("sv_mapRotationCurrent", ("gametype " + type + " map " + map));
    level.plr closeMenu();
    level.plr closeInGameMenu();
	wait 0.1;
    level.plr openMenu("mbot_restart");
  }
}


buildNodeInfo(file)
{
	iprintln(file);
	println("\nLoading bot waypoints from ", file, " ...");
	f = openfile(file, "read");
	if(f == -1)
	{
		println(file, ": ^1Error! file not found\n");
		return false;
	}

	freadln(f);
	s = fgetarg(f, 0);
	if(!isdefined(s) || s != "mbotwp")
	{	
		closefile(f);
		println(file, ": ^1Error! Unknown file format.\n");
		return false;
	}

	i = 0;
	while(freadln(f) != -1)
	{
		s = fgetarg(f, 0);
		t = strtok(s, " ,");

		level.wp[i] = spawnstruct();
		level.wp[i].origin = (strtoflt(t[0]), strtoflt(t[1]), strtoflt(t[2]));

		/*
		//level.wp[i].origin += (0,0,5);
		trace = bulletTrace(level.wp[i].origin, level.wp[i].origin+(0,0,-100), false, undefined);
		if (trace["fraction"] != 1)
			level.wp[i].origin = trace["position"];
		*/
		
		switch(t[3])
		{
			case "w":
				level.wp[i].type = "w";
				level.wp[i].next = [];
				level.wp[i].stance = int(t[4]);

				for(k = 0; k < int(t[5]); k++)
					level.wp[i].next[k] = int(t[6+k]);

				// Cepe7a -->
				if (t.size == 9)
				{
					k += 6;
					level.wp[i].angles = (strtoflt(t[k]), strtoflt(t[k+1]), 0.0);
				}
				// <-- Cepe7a
			break;
			
			case "g":
				level.wp[i].type = "g";
				level.wp[i].next = [];
				level.wp[i].stance = int(t[4]);

				k = 0;
				for(k = 0; k < int(t[5]); k++)
					level.wp[i].next[k] = int(t[6+k]);
          
				k += 6;
				level.wp[i].angles = (strtoflt(t[k]), strtoflt(t[k+1]), 0.0);

			break;
			
			case "f":
				level.wp[i].type = "f";
				level.wp[i].next = [];
				level.wp[i].stance = int(t[4]);

				for(k = 0; k < int(t[5]); k++)
					level.wp[i].next[k] = int(t[6+k]);
			break;
			
			case "c":
				level.wp[i].type = "c";
				level.wp[i].next = [];
				level.wp[i].stance = int(t[4]);

				k = 0;
				for(k = 0; k < int(t[5]); k++)
					level.wp[i].next[k] = int(t[6+k]);

				k += 6;
				level.wp[i].angles = (strtoflt(t[k]), strtoflt(t[k+1]), 0.0);
			break;
			
			case "j":
				level.wp[i].type = "j";
				level.wp[i].next = [];
				level.wp[i].stance = int(t[4]);

				for(k = 0; k < int(t[5]); k++)
					level.wp[i].next[k] = int(t[6+k]);
			break;
		
			case "m":
				level.wp[i].type = "m";
				level.wp[i].next = [];
				level.wp[i].stance = int(t[4]);

				k = 0;
				for(k = 0; k < int(t[5]); k++)
					level.wp[i].next[k] = int(t[6+k]);

				k += 6;
				level.wp[i].mode = int(t[k]);
			break;
			
			case "l":
				level.wp[i].type = "l";
				level.wp[i].next = [];
				level.wp[i].stance = int(t[4]);

				for(k = 0; k < int(t[5]); k++)
					level.wp[i].next[k] = int(t[6+k]);
			break;
			
			default:
				closefile(f);
				println(file + ": ^1Error! Waypoint #" + i + " has unknown type.\n");
				return false;
		}
		i++;
	}
	closefile(f);
  
	if(i == 0)
	{
		println(file + ": ^1Error! No data found.\n");
		return false;
	}
  
	for(k = 0; k < level.wp.size; k++)
	{
		if(level.wp[k].next.size == 0)
			println(file, (": ^3Warning! Waypoint #" + k + " have no next waypoints"));
     
		if((level.wp[k].type == "f" || level.wp[k].type == "j" || level.wp[k].type == "m" || level.wp[k].type == "l") && level.wp[k].next.size > 1)
			println(file, (": ^3Warning! Waypoint #" + k + " of type \"" + level.wp[k].type + "\" have more then one next waypoints"));
	}

	
	// MAKE COMPATIBLE FOR ROTU-ALGO!
	level.wpCount = level.wp.size;
	for (i=0; i<level.wpCount; i++)
	{
		output = "wp="+i;
		
		// init the links
		level.wp[i].linked = [];
		level.wp[i].linkedCount = level.wp[i].next.size;
		level.wp[i].ID = i;
		
		for (ii=0; ii<level.wp[i].next.size; ii++)
		{
			link_id = level.wp[i].next[ii];
			//output += " link[" + link_id + "]";
			level.wp[i].linked[ii] = level.wp[i];
		}
		//iprintln(output);
	}
	
	graph = mod\graph::GRAPH_new();
	for (i=0; i<level.wpCount; i++)
	{
		wp = level.wp[i].origin;
		mod\graph::GRAPH_add_vertex(graph, wp[0], wp[1], wp[2]);
	}
	for (i=0; i<level.wpCount; i++)
	{
		wp = level.wp[i];
		next = wp.next;
		for (ii=0; ii<wp.linkedCount; ii++)
			mod\graph::GRAPH_add_edge(graph, i, next[ii]);
	}
	mod\graph::GRAPH_build(graph);
	level.graph = graph;
	
	println("Loaded.\n");
	return true;
}


getNextNode()
{
  next = undefined;
  
	// Cepe7a -->
	self.skipmove = undefined;
	if (isDefined(self.gotostart) && isDefined(level.startwp))
	{
		next = level.wp[level.startwp];
		self.gotostart = undefined;
		self.skipmove = true;
		self.botorg moveto(next.origin, 0.01, 0, 0);
		self.botorg waittill("movedone");
		return next;
	}
	if (isdefined(level.startwp) && (!isdefined(self.next) || (isdefined(level.endwp) && self.next == level.wp[level.endwp] && self.next != level.wp[level.startwp])))
	{
		next = level.wp[level.startwp];
		self.skipmove = true;
		self.botorg moveto(next.origin, 0.01, 0, 0);
		self.botorg waittill("movedone");
		return next;
	}
	// <-- Cepe7a
			
	if(isdefined(self.next) && self.next.next.size != 0)
	{
		n = randomInt(self.next.next.size);
		next = level.wp[self.next.next[n]];
	}
	else
	{
		// Cepe7a -->
		if (isdefined(level.startwp) && self.next != level.wp[level.startwp])
		{
			next = level.wp[level.startwp];
			self.skipmove = true;
			self.botorg moveto(next.origin, 0.01, 0, 0);
			self.botorg waittill("movedone");
			return next;
		}
		// <-- Cepe7a
		
		next = self findStartNode();
	}
  
	return next;
}


findStartNode()
{
	if(isdefined(level.spawnpoints))   //  32      ,        
	{
		for(i = 0; i < level.spawnpoints.size; i++)
		{
			if(distance(self.origin, level.spawnpoints[i].origin) < 16)
				return level.wp[i];
			wait 0.01;
		}
	}

	// Cepe7a -->
	next = undefined;
	for (;;)
	{
		next = level.wp[randomInt(level.spawnpoints.size)];
		if (!isDefined(self.next) || self.next != next)
			break;
	}
		
	return next;
	// <-- Cepe7a
}


/*


checkBotCollision()
{
	players = getentarray("player", "classname");
	for(i = 0; i < players.size; i++)
	{
		player = players[i];
		dist = distance(self.origin, player.origin);
    
		if(player == self || !isalive(player) || dist > 96)
			continue;

			if(dist < 32) //         
			{
				return false;
				//if(randomInt(2))
				//	return true;
				//else
				//	return false;
			}
			
		else if (dist < 64)
		{
			
			
			if(isdefined(player.next) && self.next.origin == player.next.origin && closer(self.next.origin, player.origin, self.origin))
			{
				//if (isdefined(player.alert) && player.alert && isDefined(player.enemy))
				//{
				//	//self StopRotate();
				//	DoRotateOrg(player.enemy.origin, 0.1);
				//}
				return true;
			}

			if (self.next.next.size)
			{
				next = level.wp[self.next.next[0]];
				if (isDefined(player.next) && next.origin == player.next.origin)
					return true;
			}
			
		
			//if (isDefined(player.next) && player.next.origin != self.next.origin)
				//return false;

		}
	}
  
	return false;
}


checkPlayerCollision()
{
  if(isalive(level.plr))
  {
    if(distance(self.origin, level.plr.origin) < 50)
    {
      vec1 = vectorNormalize(self.next.origin - self.origin);
      vec2 = vectorNormalize(level.plr.origin - self.origin);
      dot = vectordot(vec1, vec2);

      if(dot > .5)
        return true;
    }
  }
  
  return false;
}


goToNode(nodeOrg)
{
	self endon("killed_player");
	self endon("stopmove");
	//self.botorg endon("movedone");
  
	if(nodeOrg == self.botorg.origin || isDefined(self.skipmove))
	{
		self.skipmove = undefined;
		self.state = "idle";
		return;
	}
  
	dist = distance(self.botorg.origin, nodeOrg); // Cepe7a
	moveTime = dist/level.movespeed;
	target = vectorNormalize(nodeOrg - self.origin);
	angles = vectorToAngles(target);
  
	// Cepe7a -->
	//self setplayerangles(angles);
	self StopRotate();
	self thread DoRotateOrg(nodeOrg, randomFloat(2-(level.botskill*0.2))+0.1); 
	// <-- Cepe7a

	self thread mbot_playLoopSound("step_bot_run", .43);
  
	self.botorg moveto(nodeOrg, moveTime, 0, 0);
	
	while (1)
	{
		if (distance(self.origin, nodeOrg) < 32)
		{
			self.state = "idle";
			return;
		}
		wait 0.1;
	}
}

stopMoving()
{
	self endon("killed_player");
	self notify("stopmove");
	self.skiprotate = undefined;
	self StopRotate();

	self mbot_stopLoopSound();
	self.botorg moveto((self.origin + (1, 1, 0)), 0.01, 0, 0);
}

throwGrenade()
{
	self endon("killed_player");

	if(self.botgrenadecount > 0)
	{
		weapon = self.pers["weapon"];
	
		// Cepe7a -->
		//self setplayerangles(self.next.angles);
		self.skiprotate = undefined;
		self StopRotate();
		self DoRotateAng(self.next.angles, 1-(level.botskill*0.1)+0.1);
		// <-- Cepe7a
		
		self addBotWeapon(self.botgrenade, 9999, 3);

		for(i = 0; i < 3; i++)             //   
		{
			self freezecontrols(false);
			wait .3;
		}

		
		self freezecontrols(true);
		self.botgrenadecount--;
		self addBotWeapon(weapon, 9999, self.pclipammo);
		self setWeaponClipAmmo(self.grenadetype, self.botgrenadecount);
	}
	self.state = "done";
}

fallGravity()
{
	self endon("killed_player");
	
	if(isdefined(self.next.next[0]))
	{
		destOrg = level.wp[self.next.next[0]].origin;

		ang = vectorToAngles((vectorNormalize(destOrg - self.next.origin)));
		vel = anglesToForward((0.0, ang[1], 0.0));
		
		// Cepe7a -->
		dst = distance((self.next.origin[0], self.next.origin[1], 0), (destOrg[0], destOrg[1], 0));
		height = self.next.origin[2] - destOrg[2];
		sqr = getvelsqr(height);
		dst = (dst) / sqr;
		
		if (dst > 240)
			dst = 240;
		vel = (vel[0]*dst, vel[1]*dst, 0);
		
		//self setplayerangles((30.0, ang[1], 0.0));
		self StopRotate();
		self thread DoRotateAng((30.0, ang[1], 0.0), 0.1);
		// <-- Cepe7a
			
		weapon = undefined;
		weaponModel = undefined;
		if(height > 64)
		{
			weapon = self.pers["weapon"];
			weaponModel = getWeaponModel(weapon);
			self attach(weaponModel, "tag_weapon_right");
			self addBotWeapon("jump_bot", 0, 0);
		}

		self.botorg movegravity(vel, sqr);
		self.botorg waittill("movedone");
		
		self thread playSurface("Land_"); // Cepe7a
		
		if(height > 64)
		{
			self addBotWeapon(weapon, 9999, self.pclipammo);
			self detach(weaponModel, "tag_weapon_right");
		}
		
		self.botorg moveto(destOrg, 0.01, 0, 0);
		self.botorg waittill("movedone");
		
	}

	self.state = "done";
}


jumpGravity()
{
	self endon("killed_player");
	
	if(isdefined(self.next.next[0]))
	{
		destOrg = level.wp[self.next.next[0]].origin;

		// Cepe7a -->
		vmax = 240;
		ang = vectorToAngles((vectorNormalize(destOrg - self.next.origin)));
		ang = (0, ang[1], 0);
		vel = anglesToForward(ang);
		vel = (vel[0], vel[1], 1);
		
		
		dst = distance(destOrg, self.next.origin);
		if (destOrg[2] >= self.next.origin[2])
		{
			dst = dst * 1.6;
			if (dst > vmax)
				dst = vmax;
			vel = (dst*vel[0], dst*vel[1], vmax);
		} 
		else
		{
			h = self.next.origin[2] - destOrg[2];
			dst = dst*1.6 - h*(1.25+h/(vmax*10));
			if (dst > vmax)
				dst = vmax;
			vel = (dst*vel[0], dst*vel[1], vmax);
		}
		
		//self setplayerangles(ang);
		self.skiprotate = undefined;
		self StopRotate();
		self thread DoRotateAng(ang, 0.5);
		// <-- Cepe7a
    
		weapon = self.pers["weapon"];
		weaponModel = getWeaponModel(weapon);
		self attach(weaponModel, "tag_weapon_right");
		self addBotWeapon("jump_bot", 0, 0);
    
		self.botorg movegravity(vel, 10);
		
		// Cepe7a -->		
		if (destOrg[2] >= self.next.origin[2])
		{
			//  
			wait 0.5;
			while(self.botorg.origin[2] > destOrg[2])
			{
				wait .01;
			}
		}
		else
		{
			//  
			wait 0.5;
			while(self.botorg.origin[2] > destOrg[2]+32 )
			{
				wait .01;
			}
		}
		// <-- Cepe7a

		
		self thread playSurface("Land_"); // Cepe7a
		
		self.botorg moveto(destOrg, 0.1, 0, 0);
		self.botorg waittill("movedone");
		
		//self.botorg playsound("bot_land");
    
		self addBotWeapon(weapon, 9999, self.pclipammo);
		self detach(weaponModel, "tag_weapon_right");
	}

	self.state = "done";
}


doMantle()
{
  self endon("killed_player");
  
  if(isdefined(self.next.next[0]))
  {
	// Cepe7a -->
	self.skiprotate = undefined;
	self StopRotate();
	wait 0.1;
	// <-- Cepe7a
	
    next = level.wp[self.next.next[0]];
    dist = distance(self.next.origin, next.origin);
    
    ang = vectorToAngles((vectorNormalize(next.origin - self.next.origin)));
  
    vec = anglesToForward((-80.0, ang[1], 0.0));
    vec = maps\mp\_utility::vectorScale(vec, dist);
    destOrg = self.next.origin + vec;
  
    self setplayerangles((20, ang[1], 0));

    weapon = self.pers["weapon"];
    self addBotWeapon("mantle_up_bot", 0, 0);
    
    self.botorg playSound("bot_raise_weap");
    
    wait .25;

    moveTime = distance(self.next.origin, destOrg)/100;
    self.botorg moveto(destOrg, moveTime, 0, 0);
    self.botorg waittill("movedone");
    
    if(self.next.mode == 1 && isdefined(next.next[0])) //  mantle_over
    {
      self.next = next;
      
      vec = anglesToForward((10, ang[1], 0));
      vec = maps\mp\_utility::vectorScale(vec, 32);
      destOrg = self.next.origin + vec;
      moveTime = distance(self.botorg.origin, destOrg)/100;
      
      // 
      self addBotWeapon("mantle_over_bot", 0, 0);
      
      wait .1;

      self.botorg moveto(destOrg, moveTime, 0, 0);
      self.botorg waittill("movedone");
      
      //   
      self addBotWeapon(weapon, 9999, self.pclipammo);
      self.state = "fall";
      
      destOrg = level.wp[self.next.next[0]].origin + (0, 0, 20);
      self.botorg movegravity((0.0, 0.0, 0.0), 10);
      while(self.botorg.origin[2] > destOrg[2])
        wait .01;

      self.botorg moveto((destOrg - (0, 0, 20)), .075, 0, 0);  // movez  
      self.botorg playsound("bot_land");
      self.botorg waittill("movedone");
    }
    else
    {
      self addBotWeapon(weapon, 9999, self.pclipammo);
    }
  }
  
  self.state = "done";
}


climbUp()
{
  self endon("killed_player");

  if(isdefined(self.next.next[0]))
  {
    next = level.wp[self.next.next[0]];
    
    height = next.origin[2] - self.next.origin[2] - 10;
    if(height < 10)
    {
      self.state = "done";
      return;
    }

    destOrg = self.next.origin + (0.0, 0.0, height);
    moveTime = distance(self.next.origin, destOrg)/100;

	// Cepe7a -->
	self.skiprotate = undefined;
	self StopRotate();
	wait 0.1;
	// <-- Cepe7a
	
    ang = vectorToAngles((vectorNormalize(next.origin - self.next.origin)));
    self setplayerangles((-50, ang[1], 0));
    
    self.botorg playSound("bot_raise_weap");
    weapon = self.pers["weapon"];
    self addBotWeapon("climb_up_bot", 0, 0);
    
    self thread mbot_playLoopSound("step_bot_climb", .4);
    
    self.botorg moveto(destOrg, moveTime, 0, 0);
    self.botorg waittill("movedone");
    
    self mbot_stopLoopSound();
    
    self addBotWeapon(weapon, 9999, self.pclipammo);
  }
  
  self.state = "done";
}


makeCamp(time)
{
	self endon("killed_player");
  
	if(isdefined(self.next.angles))
	{
		// Cepe7a -->
		//self setplayerangles(self.next.angles);
		self StopRotate();
		self DoRotateAng(self.next.angles, 0.5);
		// <-- Cepe7a
	}

	self.pclipammo = self getweaponslotclipammo("primary");
	self setweaponslotammo("primary", 0);
	self setweaponslotclipammo("primary", 0);
  
	self freezecontrols(false);
	
	// Cepe7a -->
	n = int(time / 0.1);
	for (i=0; i<n; i++)
	{
		wait 0.1;
		if (isDefined(self.gotostart))
			break;
	}
	//wait time;
	// <-- Cepe7a
	
  
	if(!self.alert)
	{
		self freezecontrols(true);
		self givemaxammo(self.pers["weapon"]);
		self setweaponslotclipammo("primary", self.pclipammo);
  
		wait 1;      //     
	}
  
	self.state = "done";
}


mbot_playLoopSound(alias, interval)
{
	self endon("stoploopsound");
  
	if(!isdefined(self.isPlayingLoopSound) || !self.isPlayingLoopSound)
	{
		self.isPlayingLoopSound = true;
    
		if (alias == "step_bot_run") 
		{
			while(isdefined(self.botorg))
			{
				self thread playSurface("step_walk_");
				wait interval;	  
			}
		}
		else
		{
			while(isdefined(self.botorg))
			{
				self.botorg playSound(alias);
				wait interval;	  
			}
		}
	}
}


mbot_stopLoopSound()
{
  self.isPlayingLoopSound = false;
  self notify("stoploopsound");
}


addMark(tagname)
{
	i = self.mark.size;
	self.mark[i] = spawn("script_origin", (0, 0, 0));
	self.mark[i] linkto(self, tagname, (0, 0, 0), (0, 0, 0));
}


markTarget() 
{
	if(!isdefined(self))
		return;
		
	wait 0.1;

	self.mark = [];

	self addMark("j_spine1"); 			// 0 
	self addMark("tag_eye");  			// 1  - Must be 2nd!
	self addMark("j_elbow_bulge_le"); 	// 2  
	self addMark("j_elbow_bulge_ri"); 	// 3  
	self addMark("j_shoulder_le");		// 4 
	self addMark("j_shoulder_ri");		// 5 
	self addMark("j_hip_le");			// 6  
	self addMark("j_hip_ri");			// 7  
	self addMark("j_ankle_le");		    // 8  
	self addMark("j_ankle_ri");			// 9  
	
	wait 0.1;

	self notify("marked");
}


endMap()
{
	map = getCvar("mapname");
	type = getCvar("g_gametype");

	if(meatbot\_mbot::mapIsSupportBots(map, type))
		meatbot\_mbot::loadMap(map, type);
	else
		map_restart(false);
}


PlayerKilled(sMeansOfDeath)
{
    self.skiprotate = undefined; // Cepe7a
	
	if(isdefined(self.mark)) {
		for(i = 0; i < self.mark.size; i++) 
		{
			self.mark[i] unlink();
			self.mark[i] delete();
		}
		self.mark = undefined;
	}
}


spawnPlayer()
{
	self markTarget();
	
	if (isDefined(self.isbot)) // Cepe7a
	{
		self notify("bot_spawned");
		self notify("test", 1, 2, 3);
	}
}


playSurface(alias)
{
	trace=bulletTrace(self.origin, self.origin-(0,0,512), false, self); 
	//iprintln(trace["surfacetype"]); // *** TEMP
	if (trace["surfacetype"] == "none")
		self playsound(alias+"default");
	else
		self playsound(alias+trace["surfacetype"]);
}


DoRotateOrg(target, roundsec)
{
	self endon("stoprotate");
	self endon("killed_player");
	
	if (isDefined(self.skiprotate))
		return;
		
	newangles = vectorToAngles(vectorNormalize(target - self.origin));
	self thread DoRotateAng(newangles, roundsec);
}


DoRotateAng(newangles, roundsec)
{
	// roundsec -     (.)
	
	self endon("stoprotate");
	self endon("killed_player");
	
	if (isDefined(self.skiprotate))
		return;
	
	iter = 20; // -     (360 )
	
	iterinc = 360/iter;
	iterwait = roundsec/iter;
	
	angles = vectorToAngles(anglestoforward(self getplayerangles()));
	newangles = vectorToAngles(anglestoforward(newangles));
	
	yaw = angleSubtract(newangles[1], angles[1]);
	pitch = angleSubtract(newangles[0], angles[0]);
	
	if (yaw < 0)
		dyaw = iterinc * (-1);
	else
		dyaw = iterinc;
	
	if (pitch < 0)
		dpitch = iterinc * (-1);
	else
		dpitch = iterinc;
		
	iyaw = abs(yaw) / iterinc;
	ipitch = abs(pitch) / iterinc;
	
	
	while (1)
	{
		if (iyaw > 1)
			angles = anglesAdd(angles, (0, dyaw, 0));
		if (ipitch > 1)
			angles = anglesAdd(angles, (dpitch, 0, 0));
			
		self setplayerangles(angles);
	
		if (iyaw > 1)
			iyaw -= 1;
		if (ipitch > 1)
			ipitch -= 1;
			
		if (iyaw <= 1 && ipitch <= 1)
			break;
		wait iterwait;
	}
	self setplayerangles(newangles);
	self notify("endrotate");
}


StopRotate()
{
	if (isDefined(self.skiprotate))
		return;
	self notify("stoprotate"); 
	wait 0.01;
}


BlockRotate(time)
{
	self notify("stopblockrotate");
	self endon("stopblockrotate");
	self endon("killed_player");
	
	self.skiprotate = true;
	wait time;
	self.skiprotate = undefined;	
}


PlayerDamage(eAttacker, iDamage,sMeansOfDeath)
{
	self endon("killed_player");
	
	if (!isDefined(self.isbot) || !isPlayer(eAttacker) || self == eAttacker)
		return;
		
	//iprintln(sMeansOfDeath); // *** TEMP
		
	if (!isDefined(self.state) || self.state == "mantle" || self.state == "climb")
		return;
		
	if (isDefined(self.alert) && !self.alert)
	{		
		self notify("stoprotate");
		self notify("endrotate");
		wait 0.01;
	
		self thread DoRotateOrg(eAttacker.origin, randomFloat(1-(level.botskill*0.1))+0.1);
		self thread BlockRotate(1);
	}
}


*/